/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.parser.DataFormatException;
import java.util.Objects;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cql.engine.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.cr.common.ResourceResolver;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractProcessor;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractRequest;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.IExtractProcessor;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.monad.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionnaireResponseProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(QuestionnaireResponseProcessor.class);
    protected final ResourceResolver resourceResolver;
    protected final ModelResolver modelResolver;
    protected final EvaluationSettings evaluationSettings;
    protected final FhirVersionEnum fhirVersion;
    protected Repository repository;
    protected IExtractProcessor extractProcessor;

    public QuestionnaireResponseProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public QuestionnaireResponseProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        this(repository, evaluationSettings, null);
    }

    public QuestionnaireResponseProcessor(Repository repository, EvaluationSettings evaluationSettings, IExtractProcessor extractProcessor) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.resourceResolver = new ResourceResolver("QuestionnaireResponse", this.repository);
        this.fhirVersion = this.repository.fhirContext().getVersion().getVersion();
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)this.fhirVersion);
        this.extractProcessor = extractProcessor != null ? extractProcessor : new ExtractProcessor();
    }

    public FhirContext fhirContext() {
        return this.repository.fhirContext();
    }

    protected <R extends IBaseResource> R resolveQuestionnaireResponse(Either<IIdType, R> questionnaireResponse) {
        return this.resourceResolver.resolve(questionnaireResponse);
    }

    protected IBaseResource resolveQuestionnaire(IBaseResource questionnaireResponse) {
        try {
            Object pathResult;
            Object canonical = questionnaireResponse.getStructureFhirVersionEnum().equals((Object)FhirVersionEnum.DSTU3) ? ((pathResult = this.modelResolver.resolvePath((Object)questionnaireResponse, "questionnaire")) == null ? null : ((IBaseReference)pathResult).getReferenceElement()) : (IPrimitiveType)this.modelResolver.resolvePath((Object)questionnaireResponse, "questionnaire");
            return canonical == null ? null : SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)canonical, (Class)this.repository.fhirContext().getResourceDefinition("questionnaire").getImplementingClass());
        }
        catch (DataFormatException | FHIRException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public <R extends IBaseResource> IBaseBundle extract(Either<IIdType, R> resource) {
        return this.extract(resource, null, null);
    }

    public <R extends IBaseResource> IBaseBundle extract(Either<IIdType, R> resource, IBaseParameters parameters, IBaseBundle bundle) {
        return this.extract(resource, parameters, bundle, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <R extends IBaseResource> IBaseBundle extract(Either<IIdType, R> resource, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        R questionnaireResponse = this.resolveQuestionnaireResponse(resource);
        IBaseResource questionnaire = this.resolveQuestionnaire((IBaseResource)questionnaireResponse);
        IBaseReference subject = (IBaseReference)this.modelResolver.resolvePath(questionnaireResponse, "subject");
        ExtractRequest request = new ExtractRequest((IBaseResource)questionnaireResponse, questionnaire, subject == null ? null : subject.getReferenceElement(), parameters, bundle, libraryEngine, this.modelResolver, this.repository.fhirContext());
        return this.extractProcessor.extract(request);
    }
}

