/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;

public class PackageHelper {
    public static IBaseBackboneElement createEntry(IBaseResource resource, boolean isPut) {
        KnowledgeArtifactAdapter adapter;
        String method;
        FhirVersionEnum fhirVersion = resource.getStructureFhirVersionEnum();
        IBaseBackboneElement entry = BundleHelper.newEntryWithResource(resource.getStructureFhirVersionEnum(), resource);
        Object requestUrl = resource.fhirType();
        if (isPut) {
            method = "PUT";
            if (resource.getIdElement() != null && !StringUtils.isBlank((CharSequence)resource.getIdElement().getIdPart())) {
                requestUrl = (String)requestUrl + "/" + resource.getIdElement().getIdPart();
            }
        } else {
            method = "POST";
        }
        IBaseBackboneElement request = BundleHelper.newRequest(fhirVersion, method, (String)requestUrl);
        BundleHelper.setEntryRequest(fhirVersion, entry, request);
        if (KnowledgeArtifactAdapter.isSupportedMetadataResource(resource) && (adapter = AdapterFactory.forFhirVersion(fhirVersion).createKnowledgeArtifactAdapter((IDomainResource)resource)).hasUrl()) {
            String url = adapter.getUrl();
            if (adapter.hasVersion()) {
                BundleHelper.setEntryFullUrl(fhirVersion, entry, url + "|" + adapter.getVersion());
                if (!isPut) {
                    BundleHelper.setRequestIfNoneExist(fhirVersion, request, String.format("url=%s&version=%s", url, adapter.getVersion()));
                }
            } else {
                BundleHelper.setEntryFullUrl(fhirVersion, entry, url);
                if (!isPut) {
                    BundleHelper.setRequestIfNoneExist(fhirVersion, request, String.format("url=%s", url));
                }
            }
        }
        return entry;
    }
}

