/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IQueryParameterType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r5.model.Bundle;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.search.Searches;

public class SearchHelper {
    private SearchHelper() {
    }

    protected static Class<IBaseBundle> getBundleClass(Repository repository) {
        return repository.fhirContext().getResourceDefinition("Bundle").getImplementingClass();
    }

    protected static Class<IBaseResource> getResourceClass(Repository repository, String resourceType) {
        return repository.fhirContext().getResourceDefinition(resourceType).getImplementingClass();
    }

    public static IBaseResource readRepository(Repository repository, IIdType id) {
        return repository.read(SearchHelper.getResourceClass(repository, id.getResourceType()), id);
    }

    public static <CanonicalType extends IPrimitiveType<String>> IBaseResource searchRepositoryByCanonical(Repository repository, CanonicalType canonical) {
        Class resourceType = repository.fhirContext().getResourceDefinition(Canonicals.getResourceType(canonical)).getImplementingClass();
        return SearchHelper.searchRepositoryByCanonical(repository, canonical, resourceType);
    }

    public static <CanonicalType extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource searchRepositoryByCanonical(Repository repository, CanonicalType canonical, Class<R> resourceType) {
        String url = Canonicals.getUrl(canonical);
        String version = Canonicals.getVersion(canonical);
        Map<String, List<IQueryParameterType>> searchParams = version == null ? Searches.byUrl(url) : Searches.byUrlAndVersion(url, version);
        IBaseBundle searchResult = repository.search(SearchHelper.getBundleClass(repository), resourceType, searchParams);
        IBaseResource result = BundleHelper.getEntryResourceFirstRep(searchResult);
        if (result == null) {
            throw new FHIRException(String.format("No resource of type %s found for url: %s|%s", resourceType.getSimpleName(), url, version));
        }
        return result;
    }

    public static <CanonicalType extends IPrimitiveType<String>> IBaseBundle searchRepositoryByCanonicalWithPaging(Repository repository, CanonicalType canonical) {
        Class resourceType = repository.fhirContext().getResourceDefinition(Canonicals.getResourceType(canonical)).getImplementingClass();
        return SearchHelper.searchRepositoryByCanonicalWithPaging(repository, canonical, resourceType);
    }

    public static <CanonicalType extends IPrimitiveType<String>> IBaseBundle searchRepositoryByCanonicalWithPaging(Repository repository, String canonical) {
        Class resourceType = repository.fhirContext().getResourceDefinition(Canonicals.getResourceType(canonical)).getImplementingClass();
        return SearchHelper.searchRepositoryByCanonicalWithPaging(repository, canonical, resourceType);
    }

    public static <CanonicalType extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle searchRepositoryByCanonicalWithPaging(Repository repository, CanonicalType canonical, Class<R> resourceType) {
        String url = Canonicals.getUrl(canonical);
        String version = Canonicals.getVersion(canonical);
        Map<String, List<IQueryParameterType>> searchParams = version == null ? Searches.byUrl(url) : Searches.byUrlAndVersion(url, version);
        R searchResult = SearchHelper.searchRepositoryWithPaging(repository, resourceType, searchParams, Collections.emptyMap());
        return searchResult;
    }

    public static <R extends IBaseResource> IBaseBundle searchRepositoryByCanonicalWithPaging(Repository repository, String canonical, Class<R> resourceType) {
        String url = Canonicals.getUrl(canonical);
        String version = Canonicals.getVersion(canonical);
        Map<String, List<IQueryParameterType>> searchParams = version == null ? Searches.byUrl(url) : Searches.byUrlAndVersion(url, version);
        R searchResult = SearchHelper.searchRepositoryWithPaging(repository, resourceType, searchParams, Collections.emptyMap());
        return searchResult;
    }

    public static <T extends IBaseResource, R extends IBaseBundle> R searchRepositoryWithPaging(Repository repository, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        Class<IBaseBundle> bundleClass = SearchHelper.getBundleClass(repository);
        IBaseBundle result = repository.search(bundleClass, resourceType, searchParameters, headers);
        SearchHelper.handlePaging(repository, result);
        return (R)result;
    }

    private static void handlePaging(Repository repository, IBaseBundle bundle) {
        FhirVersionEnum fhirVersion = repository.fhirContext().getVersion().getVersion();
        switch (fhirVersion) {
            case DSTU3: {
                org.hl7.fhir.dstu3.model.Bundle dstu3Bundle = (org.hl7.fhir.dstu3.model.Bundle)bundle;
                Bundle.BundleLinkComponent dstu3Next = dstu3Bundle.getLink("next");
                if (dstu3Next == null) break;
                SearchHelper.getNextPageDstu3(repository, dstu3Bundle, dstu3Next.getUrl());
                break;
            }
            case R4: {
                Bundle r4Bundle = (Bundle)bundle;
                Bundle.BundleLinkComponent r4Next = r4Bundle.getLink("next");
                if (r4Next == null) break;
                SearchHelper.getNextPageR4(repository, r4Bundle, r4Next.getUrl());
                break;
            }
            case R5: {
                org.hl7.fhir.r5.model.Bundle r5Bundle = (org.hl7.fhir.r5.model.Bundle)bundle;
                Bundle.BundleLinkComponent r5Next = r5Bundle.getLink("next");
                if (r5Next == null) break;
                SearchHelper.getNextPageR5(repository, r5Bundle, r5Next.getUrl());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported version of FHIR: %s", fhirVersion.getFhirVersionString()));
            }
        }
    }

    private static void getNextPageDstu3(Repository repository, org.hl7.fhir.dstu3.model.Bundle bundle, String nextUrl) {
        org.hl7.fhir.dstu3.model.Bundle nextBundle = (org.hl7.fhir.dstu3.model.Bundle)repository.link(org.hl7.fhir.dstu3.model.Bundle.class, nextUrl);
        nextBundle.getEntry().forEach(arg_0 -> ((org.hl7.fhir.dstu3.model.Bundle)bundle).addEntry(arg_0));
        Bundle.BundleLinkComponent next = nextBundle.getLink("next");
        if (next != null) {
            SearchHelper.getNextPageDstu3(repository, bundle, next.getUrl());
        }
    }

    private static void getNextPageR4(Repository repository, Bundle bundle, String nextUrl) {
        Bundle nextBundle = (Bundle)repository.link(Bundle.class, nextUrl);
        nextBundle.getEntry().forEach(arg_0 -> ((Bundle)bundle).addEntry(arg_0));
        Bundle.BundleLinkComponent next = nextBundle.getLink("next");
        if (next != null) {
            SearchHelper.getNextPageR4(repository, bundle, next.getUrl());
        }
    }

    private static void getNextPageR5(Repository repository, org.hl7.fhir.r5.model.Bundle bundle, String nextUrl) {
        org.hl7.fhir.r5.model.Bundle nextBundle = (org.hl7.fhir.r5.model.Bundle)repository.link(org.hl7.fhir.r5.model.Bundle.class, nextUrl);
        nextBundle.getEntry().forEach(arg_0 -> ((org.hl7.fhir.r5.model.Bundle)bundle).addEntry(arg_0));
        Bundle.BundleLinkComponent next = nextBundle.getLink("next");
        if (next != null) {
            SearchHelper.getNextPageR5(repository, bundle, next.getUrl());
        }
    }
}

