/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.adapter.AttachmentAdapter;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.LibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.ParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.ResourceAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.ParametersParameterComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.PlanDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.ValueSetAdapter;

public class AdapterFactory
implements org.opencds.cqf.fhir.utility.adapter.AdapterFactory {
    @Override
    public ResourceAdapter createResource(IBaseResource resource) {
        if (resource instanceof MetadataResource) {
            return this.createKnowledgeArtifactAdapter((IDomainResource)((MetadataResource)resource));
        }
        return new org.opencds.cqf.fhir.utility.adapter.dstu3.ResourceAdapter(resource);
    }

    @Override
    public KnowledgeArtifactAdapter createKnowledgeArtifactAdapter(IDomainResource resource) {
        KnowledgeArtifactAdapter retval;
        if (resource instanceof Library) {
            retval = this.createLibrary((IBaseResource)resource);
        } else if (resource instanceof PlanDefinition) {
            retval = new PlanDefinitionAdapter((PlanDefinition)resource);
        } else if (resource instanceof ValueSet) {
            retval = new ValueSetAdapter((ValueSet)resource);
        } else if (resource instanceof MetadataResource) {
            retval = new org.opencds.cqf.fhir.utility.adapter.dstu3.KnowledgeArtifactAdapter((MetadataResource)resource);
        } else {
            throw new UnprocessableEntityException(String.format("Resouce must be instance of %s", MetadataResource.class.getName()));
        }
        return retval;
    }

    @Override
    public LibraryAdapter createLibrary(IBaseResource library) {
        return new org.opencds.cqf.fhir.utility.adapter.dstu3.LibraryAdapter((IDomainResource)library);
    }

    @Override
    public AttachmentAdapter createAttachment(ICompositeType attachment) {
        return new org.opencds.cqf.fhir.utility.adapter.dstu3.AttachmentAdapter(attachment);
    }

    @Override
    public ParametersAdapter createParameters(IBaseParameters parameters) {
        return new org.opencds.cqf.fhir.utility.adapter.dstu3.ParametersAdapter((IBaseResource)parameters);
    }

    @Override
    public org.opencds.cqf.fhir.utility.adapter.ParametersParameterComponentAdapter createParametersParameters(IBaseBackboneElement parametersParametersComponent) {
        return new ParametersParameterComponentAdapter(parametersParametersComponent);
    }
}

