/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.utility.adapter.dstu3.ResourceAdapter;

class ParametersAdapter
extends ResourceAdapter
implements org.opencds.cqf.fhir.utility.adapter.ParametersAdapter {
    private Parameters parameters;

    public ParametersAdapter(IBaseResource parameters) {
        super(parameters);
        if (!parameters.fhirType().equals("Parameters")) {
            throw new IllegalArgumentException("resource passed as parameters argument is not a Parameters resource");
        }
        this.parameters = (Parameters)parameters;
    }

    protected Parameters getParameters() {
        return this.parameters;
    }

    public List<Parameters.ParametersParameterComponent> getParameter() {
        return this.getParameters().getParameter();
    }

    @Override
    public void setParameter(List<IBaseBackboneElement> parametersParameterComponents) {
        this.getParameters().setParameter(parametersParameterComponents.stream().map(x -> (Parameters.ParametersParameterComponent)x).collect(Collectors.toList()));
    }

    public Parameters.ParametersParameterComponent addParameter() {
        return this.getParameters().addParameter();
    }

    public List<Type> getParameterValues(String name) {
        return this.getParameters().getParameter().stream().filter(p -> p.getName().equals(name)).map(p -> p.getValue()).collect(Collectors.toList());
    }

    public Parameters.ParametersParameterComponent getParameter(String name) {
        return this.getParameters().getParameter().stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
    }
}

