/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.opencds.cqf.fhir.utility.FhirVersions;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.builder.CodeableConceptSettings;

public abstract class BaseBackboneElementBuilder<SELF extends BaseBackboneElementBuilder<SELF, T>, T extends IBaseBackboneElement> {
    private final Class<T> resourceClass;
    private String id = UUID.randomUUID().toString();
    private List<Pair<String, CodeableConceptSettings>> extensions;
    private List<Pair<String, CodeableConceptSettings>> modifierExtensions;

    protected BaseBackboneElementBuilder(Class<T> resourceClass) {
        Preconditions.checkNotNull(resourceClass);
        this.resourceClass = resourceClass;
    }

    protected BaseBackboneElementBuilder(Class<T> resourceClass, String id) {
        this(resourceClass);
        Preconditions.checkNotNull((Object)id);
        this.id = id;
    }

    public T build() {
        T backboneElement = Resources.newBackboneElement(this.resourceClass);
        switch (FhirVersions.forClass(this.resourceClass)) {
            case DSTU3: {
                this.initializeDstu3(backboneElement);
                break;
            }
            case R4: {
                this.initializeR4(backboneElement);
                break;
            }
            case R5: {
                this.initializeR5(backboneElement);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("ResourceBuilder.initializeResource does not support FHIR version %s", FhirVersions.forClass(this.resourceClass).getFhirVersionString()));
            }
        }
        return backboneElement;
    }

    private void addExtension(Pair<String, CodeableConceptSettings> extension) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Pair<String, CodeableConceptSettings>>();
        }
        this.extensions.add(extension);
    }

    private List<Pair<String, CodeableConceptSettings>> getExtensions() {
        if (this.extensions == null) {
            return Collections.emptyList();
        }
        return this.extensions;
    }

    protected String getId() {
        return this.id;
    }

    private void addModifierExtension(Pair<String, CodeableConceptSettings> modifierExtension) {
        if (this.modifierExtensions == null) {
            this.modifierExtensions = new ArrayList<Pair<String, CodeableConceptSettings>>();
        }
        this.modifierExtensions.add(modifierExtension);
    }

    private List<Pair<String, CodeableConceptSettings>> getModifierExtensions() {
        if (this.modifierExtensions == null) {
            return Collections.emptyList();
        }
        return this.modifierExtensions;
    }

    public SELF withId(String id) {
        Preconditions.checkNotNull((Object)id);
        this.id = id;
        return this.self();
    }

    public SELF withExtension(Pair<String, CodeableConceptSettings> extension) {
        Preconditions.checkNotNull(extension);
        this.addExtension(extension);
        return this.self();
    }

    public SELF withModifierExtension(Pair<String, CodeableConceptSettings> modifierExtension) {
        Preconditions.checkNotNull(modifierExtension);
        this.addModifierExtension(modifierExtension);
        return this.self();
    }

    protected SELF self() {
        return (SELF)this;
    }

    protected void initializeDstu3(T resource) {
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept = new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding(new Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = resource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept = new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding(new Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = resource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }

    protected void initializeR4(T resource) {
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            CodeableConcept codeableConcept = new CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = resource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            CodeableConcept codeableConcept = new CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = resource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }

    protected void initializeR5(T resource) {
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.r5.model.CodeableConcept codeableConcept = new org.hl7.fhir.r5.model.CodeableConcept().addCoding(new org.hl7.fhir.r5.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = resource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.r5.model.CodeableConcept codeableConcept = new org.hl7.fhir.r5.model.CodeableConcept().addCoding(new org.hl7.fhir.r5.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = resource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }
}

