/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.opencds.cqf.fhir.utility.builder.BaseResourceBuilder;
import org.opencds.cqf.fhir.utility.builder.CodeableConceptSettings;

public abstract class BaseDomainResourceBuilder<SELF, T extends IDomainResource>
extends BaseResourceBuilder<SELF, T> {
    private List<Pair<String, CodeableConceptSettings>> extension;
    private List<Pair<String, CodeableConceptSettings>> modifierExtension;

    protected BaseDomainResourceBuilder(Class<T> resourceClass) {
        super(resourceClass);
    }

    protected BaseDomainResourceBuilder(Class<T> resourceClass, String id) {
        super(resourceClass, id);
    }

    private void addExtension(Pair<String, CodeableConceptSettings> extension) {
        if (this.extension == null) {
            this.extension = new ArrayList<Pair<String, CodeableConceptSettings>>();
        }
        this.extension.add(extension);
    }

    private List<Pair<String, CodeableConceptSettings>> getExtensions() {
        if (this.extension == null) {
            return Collections.emptyList();
        }
        return this.extension;
    }

    private void addModifierExtension(Pair<String, CodeableConceptSettings> modifierExtension) {
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Pair<String, CodeableConceptSettings>>();
        }
        this.modifierExtension.add(modifierExtension);
    }

    private List<Pair<String, CodeableConceptSettings>> getModifierExtensions() {
        if (this.modifierExtension == null) {
            return Collections.emptyList();
        }
        return this.modifierExtension;
    }

    public SELF withExtension(Pair<String, CodeableConceptSettings> extension) {
        Preconditions.checkNotNull(extension);
        this.addExtension(extension);
        return this.self();
    }

    public SELF withModifierExtension(Pair<String, CodeableConceptSettings> modifierExtension) {
        Preconditions.checkNotNull(modifierExtension);
        this.addModifierExtension(modifierExtension);
        return this.self();
    }

    @Override
    protected SELF self() {
        return (SELF)this;
    }

    @Override
    protected void initializeDstu3(T resource) {
        super.initializeDstu3(resource);
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept = new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding(new Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = resource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept = new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding(new Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = resource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }

    @Override
    protected void initializeR4(T resource) {
        super.initializeR4(resource);
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            CodeableConcept codeableConcept = new CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = resource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            CodeableConcept codeableConcept = new CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = resource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }

    @Override
    protected void initializeR5(T resource) {
        super.initializeR5(resource);
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.r5.model.CodeableConcept codeableConcept = new org.hl7.fhir.r5.model.CodeableConcept().addCoding(new org.hl7.fhir.r5.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = resource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.r5.model.CodeableConcept codeableConcept = new org.hl7.fhir.r5.model.CodeableConcept().addCoding(new org.hl7.fhir.r5.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = resource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }
}

