/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.utility.Resources;

public abstract class BaseResourceBuilder<SELF, T extends IBaseResource> {
    public static final String DEFAULT_IDENTIFIER_SYSTEM = "urn:ietf:rfc:3986";
    public static final String DEFAULT_IDENTIFIER_VALUE_PREFIX = "urn:uuid:";
    private final Class<T> resourceClass;
    private List<String> profile;
    private String id = UUID.randomUUID().toString();
    private Pair<String, String> identifier = new ImmutablePair((Object)"urn:ietf:rfc:3986", (Object)("urn:uuid:" + UUID.randomUUID().toString()));

    protected BaseResourceBuilder(Class<T> resourceClass) {
        Preconditions.checkNotNull(resourceClass);
        this.resourceClass = resourceClass;
    }

    protected BaseResourceBuilder(Class<T> resourceClass, String id) {
        this(resourceClass);
        Preconditions.checkNotNull((Object)id);
        this.id = id;
    }

    protected SELF self() {
        return (SELF)this;
    }

    public static String ensurePatientReference(String patientId) {
        if (Strings.isNullOrEmpty((String)patientId) || patientId.startsWith("Patient/")) {
            return patientId;
        }
        return "Patient/" + patientId;
    }

    public static String ensureOrganizationReference(String organizationId) {
        if (Strings.isNullOrEmpty((String)organizationId) || organizationId.startsWith("Organization/")) {
            return organizationId;
        }
        return "Organization/" + organizationId;
    }

    private void addProfile(String profile) {
        if (this.profile == null) {
            this.profile = new ArrayList<String>();
        }
        this.profile.add(profile);
    }

    protected List<String> getProfiles() {
        if (this.profile == null) {
            return Collections.emptyList();
        }
        return this.profile;
    }

    protected String getId() {
        return this.id;
    }

    protected Pair<String, String> getIdentifier() {
        return this.identifier;
    }

    public SELF withId(String id) {
        Preconditions.checkNotNull((Object)id);
        this.id = id;
        return this.self();
    }

    public SELF withProfile(String profile) {
        Preconditions.checkNotNull((Object)profile);
        this.addProfile(profile);
        return this.self();
    }

    public SELF withIdentifier(Pair<String, String> identifier) {
        this.identifier = identifier;
        return this.self();
    }

    public T build() {
        T resource = Resources.newResource(this.resourceClass, this.id);
        switch (resource.getStructureFhirVersionEnum()) {
            case DSTU3: {
                this.initializeDstu3(resource);
                break;
            }
            case R4: {
                this.initializeR4(resource);
                break;
            }
            case R5: {
                this.initializeR5(resource);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("ResourceBuilder.initializeResource does not support FHIR version %s", resource.getStructureFhirVersionEnum().getFhirVersionString()));
            }
        }
        return resource;
    }

    private void addProfiles(T resource) {
        this.getProfiles().forEach(p -> resource.getMeta().addProfile(p));
    }

    protected void initializeDstu3(T resource) {
        this.addProfiles(resource);
    }

    protected void initializeR4(T resource) {
        this.addProfiles(resource);
    }

    protected void initializeR5(T resource) {
        this.addProfiles(resource);
    }
}

