/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.dstu3.model.DetectedIssue;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.opencds.cqf.fhir.utility.builder.BaseDomainResourceBuilder;
import org.opencds.cqf.fhir.utility.builder.CodeableConceptSettings;
import org.opencds.cqf.fhir.utility.builder.CodingSettings;

public class DetectedIssueBuilder<T extends IDomainResource>
extends BaseDomainResourceBuilder<DetectedIssueBuilder<T>, T> {
    private String status;
    private CodeableConceptSettings c;
    private String patient;
    private List<String> evidenceDetails;

    public DetectedIssueBuilder(Class<T> resourceClass) {
        super(resourceClass);
    }

    public DetectedIssueBuilder(Class<T> resourceClass, String id) {
        super(resourceClass, id);
    }

    public DetectedIssueBuilder(Class<T> resourceClass, String id, String status, String evidenceDetail) {
        super(resourceClass, id);
        Preconditions.checkNotNull((Object)status);
        Preconditions.checkNotNull((Object)evidenceDetail);
        this.status = status;
        this.addEvidenceDetail(evidenceDetail);
    }

    private void addEvidenceDetail(String evidenceDetail) {
        if (this.evidenceDetails == null) {
            this.evidenceDetails = new ArrayList<String>();
        }
        this.evidenceDetails.add(evidenceDetail);
    }

    private List<String> getEvidenceDetails() {
        if (this.evidenceDetails == null) {
            return Collections.emptyList();
        }
        return this.evidenceDetails;
    }

    public DetectedIssueBuilder<T> withStatus(String status) {
        this.status = status;
        return this;
    }

    public DetectedIssueBuilder<T> withCode(CodeableConceptSettings code) {
        Preconditions.checkNotNull((Object)code);
        this.c = code;
        return this;
    }

    public DetectedIssueBuilder<T> withPatient(String patient) {
        this.patient = DetectedIssueBuilder.ensurePatientReference(patient);
        return this;
    }

    public DetectedIssueBuilder<T> withEvidenceDetail(String evidenceDetail) {
        Preconditions.checkNotNull((Object)evidenceDetail);
        this.addEvidenceDetail(evidenceDetail);
        return this;
    }

    @Override
    public T build() {
        Preconditions.checkNotNull((Object)this.status);
        Preconditions.checkNotNull(this.evidenceDetails);
        Preconditions.checkArgument((!this.evidenceDetails.isEmpty() ? 1 : 0) != 0);
        return (T)((IDomainResource)super.build());
    }

    private CodingSettings getCodeSetting() {
        return this.c.getCodingSettingsArray()[0];
    }

    @Override
    protected void initializeDstu3(T resource) {
        super.initializeDstu3(resource);
        org.hl7.fhir.dstu3.model.DetectedIssue detectedIssue = (org.hl7.fhir.dstu3.model.DetectedIssue)resource;
        detectedIssue.setIdentifier(new Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue())).setPatient(new Reference(this.patient)).setStatus(DetectedIssue.DetectedIssueStatus.valueOf((String)this.status));
        this.getEvidenceDetails().forEach(arg_0 -> ((org.hl7.fhir.dstu3.model.DetectedIssue)detectedIssue).setReference(arg_0));
    }

    @Override
    protected void initializeR4(T resource) {
        super.initializeR4(resource);
        DetectedIssue detectedIssue = (DetectedIssue)resource;
        ArrayList<org.hl7.fhir.r4.model.Identifier> identifier = new ArrayList<org.hl7.fhir.r4.model.Identifier>();
        identifier.add(new org.hl7.fhir.r4.model.Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue()));
        detectedIssue.setIdentifier(identifier).setPatient(new org.hl7.fhir.r4.model.Reference(this.patient)).setStatus(DetectedIssue.DetectedIssueStatus.valueOf((String)this.status)).setCode(new org.hl7.fhir.r4.model.CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(this.getCodeSetting().getSystem()).setCode(this.getCodeSetting().getCode()).setDisplay(this.getCodeSetting().getDisplay())));
        this.getEvidenceDetails().forEach(evidence -> detectedIssue.addEvidence(new DetectedIssue.DetectedIssueEvidenceComponent().addDetail(new org.hl7.fhir.r4.model.Reference(evidence))));
    }

    @Override
    protected void initializeR5(T resource) {
        super.initializeR5(resource);
        org.hl7.fhir.r5.model.DetectedIssue detectedIssue = (org.hl7.fhir.r5.model.DetectedIssue)resource;
        ArrayList<org.hl7.fhir.r5.model.Identifier> identifier = new ArrayList<org.hl7.fhir.r5.model.Identifier>();
        identifier.add(new org.hl7.fhir.r5.model.Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue()));
        detectedIssue.setIdentifier(identifier).setStatus(DetectedIssue.DetectedIssueStatus.valueOf((String)this.status)).setCode(new CodeableConcept().addCoding(new Coding().setSystem(this.getCodeSetting().getSystem()).setCode(this.getCodeSetting().getCode()).setDisplay(this.getCodeSetting().getDisplay())));
        this.getEvidenceDetails().forEach(evidence -> detectedIssue.addEvidence(new DetectedIssue.DetectedIssueEvidenceComponent().addDetail(new org.hl7.fhir.r5.model.Reference(evidence))));
    }
}

