/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.interceptor.BasicAuthInterceptor;
import ca.uhn.fhir.rest.client.interceptor.BearerTokenAuthInterceptor;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Endpoint;
import org.opencds.cqf.fhir.utility.client.HeaderInjectionInterceptor;

public class Clients {
    private Clients() {
    }

    public static IGenericClient forUrl(FhirVersionEnum fhirVersionEnum, String url) {
        Preconditions.checkNotNull((Object)fhirVersionEnum);
        Preconditions.checkNotNull((Object)url);
        return Clients.forUrl(FhirContext.forCached((FhirVersionEnum)fhirVersionEnum), url);
    }

    public static IGenericClient forUrl(FhirContext fhirContext, String url) {
        Preconditions.checkNotNull((Object)fhirContext);
        Preconditions.checkNotNull((Object)url);
        return Clients.forUrl(fhirContext, url, ServerValidationModeEnum.NEVER);
    }

    public static IGenericClient forUrl(FhirVersionEnum fhirVersionEnum, String url, ServerValidationModeEnum serverValidationModeEnum) {
        Preconditions.checkNotNull((Object)fhirVersionEnum, (Object)"fhirVersionEnum is required");
        Preconditions.checkNotNull((Object)url, (Object)"url is required");
        Preconditions.checkNotNull((Object)serverValidationModeEnum, (Object)"serverValidationModeEnum is required");
        return Clients.forUrl(FhirContext.forCached((FhirVersionEnum)fhirVersionEnum), url, serverValidationModeEnum);
    }

    public static IGenericClient forUrl(FhirContext fhirContext, String url, ServerValidationModeEnum serverValidationModeEnum) {
        Preconditions.checkNotNull((Object)fhirContext);
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)serverValidationModeEnum, (Object)"serverValidationModeEnum is required");
        fhirContext.getRestfulClientFactory().setServerValidationMode(serverValidationModeEnum);
        return fhirContext.newRestfulGenericClient(url);
    }

    public static IGenericClient forEndpoint(org.hl7.fhir.dstu3.model.Endpoint endpoint) {
        Preconditions.checkNotNull((Object)endpoint);
        return Clients.forEndpoint(FhirContext.forDstu3Cached(), endpoint);
    }

    public static IGenericClient forEndpoint(FhirContext fhirContext, org.hl7.fhir.dstu3.model.Endpoint endpoint) {
        Preconditions.checkNotNull((Object)fhirContext);
        Preconditions.checkNotNull((Object)endpoint);
        IGenericClient client = Clients.forUrl(fhirContext, endpoint.getAddress());
        if (endpoint.hasHeader()) {
            List<String> headerList = endpoint.getHeader().stream().map(headerString -> headerString.asStringValue()).collect(Collectors.toList());
            Clients.registerHeaders(client, headerList);
        }
        return client;
    }

    public static IGenericClient forEndpoint(Endpoint endpoint) {
        Preconditions.checkNotNull((Object)endpoint);
        return Clients.forEndpoint(FhirContext.forR4Cached(), endpoint);
    }

    public static IGenericClient forEndpoint(FhirContext fhirContext, Endpoint endpoint) {
        Preconditions.checkNotNull((Object)fhirContext);
        Preconditions.checkNotNull((Object)endpoint);
        IGenericClient client = Clients.forUrl(fhirContext, endpoint.getAddress());
        if (endpoint.hasHeader()) {
            List<String> headerList = endpoint.getHeader().stream().map(headerString -> headerString.asStringValue()).collect(Collectors.toList());
            Clients.registerHeaders(client, headerList);
        }
        return client;
    }

    public static IGenericClient forEndpoint(org.hl7.fhir.r5.model.Endpoint endpoint) {
        Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint is required");
        return Clients.forEndpoint(FhirContext.forR4Cached(), endpoint);
    }

    public static IGenericClient forEndpoint(FhirContext fhirContext, org.hl7.fhir.r5.model.Endpoint endpoint) {
        Preconditions.checkNotNull((Object)fhirContext);
        Preconditions.checkNotNull((Object)endpoint);
        IGenericClient client = Clients.forUrl(fhirContext, endpoint.getAddress());
        if (endpoint.hasHeader()) {
            List<String> headerList = endpoint.getHeader().stream().map(headerString -> headerString.asStringValue()).collect(Collectors.toList());
            Clients.registerHeaders(client, headerList);
        }
        return client;
    }

    public static void registerHeaders(IGenericClient client, String ... headers) {
        Preconditions.checkNotNull((Object)client);
        Clients.registerHeaders(client, Arrays.asList(headers));
    }

    public static void registerHeaders(IGenericClient client, List<String> headerList) {
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull(headerList);
        Map<String, String> headerMap = Clients.setupHeaderMap(headerList);
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            HeaderInjectionInterceptor headInterceptor = new HeaderInjectionInterceptor(entry.getKey(), entry.getValue());
            client.registerInterceptor((Object)headInterceptor);
        }
    }

    public static void registerBasicAuth(IGenericClient client, String username, String password) {
        Preconditions.checkNotNull((Object)client, (Object)"client is required");
        if (username != null) {
            BasicAuthInterceptor authInterceptor = new BasicAuthInterceptor(username, password);
            client.registerInterceptor((Object)authInterceptor);
        }
    }

    public static void registerBearerTokenAuth(IGenericClient client, String token) {
        Preconditions.checkNotNull((Object)client, (Object)"client is required");
        if (token != null) {
            BearerTokenAuthInterceptor authInterceptor = new BearerTokenAuthInterceptor(token);
            client.registerInterceptor((Object)authInterceptor);
        }
    }

    static Map<String, String> setupHeaderMap(List<String> headerList) {
        Preconditions.checkNotNull(headerList, (Object)"headerList is required");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String leftAuth = null;
        String rightAuth = null;
        if (headerList.size() < 1 || headerList.isEmpty()) {
            leftAuth = null;
            rightAuth = null;
            headerMap.put(leftAuth, rightAuth);
        } else {
            for (String header : headerList) {
                if (!header.contains(":")) {
                    throw new IllegalArgumentException("Endpoint header must contain \":\" .");
                }
                String[] authSplit = header.split(":");
                leftAuth = authSplit[0];
                rightAuth = authSplit[1];
                headerMap.put(leftAuth, rightAuth);
            }
        }
        return headerMap;
    }
}

