/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.dstu3;

import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.exceptions.FHIRException;

public class CRMIReleaseVersionBehavior {

    public static class CRMIReleaseVersionBehaviorCodesEnumFactory
    implements EnumFactory<CRMIReleaseVersionBehaviorCodes> {
        public CRMIReleaseVersionBehaviorCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("default".equals(codeString)) {
                return CRMIReleaseVersionBehaviorCodes.DEFAULT;
            }
            if ("check".equals(codeString)) {
                return CRMIReleaseVersionBehaviorCodes.CHECK;
            }
            if ("force".equals(codeString)) {
                return CRMIReleaseVersionBehaviorCodes.FORCE;
            }
            throw new IllegalArgumentException("Unknown CRMIReleaseVersionBehaviorCodes code '" + codeString + "'");
        }

        public Enumeration<CRMIReleaseVersionBehaviorCodes> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration((EnumFactory)this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("default".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)CRMIReleaseVersionBehaviorCodes.DEFAULT);
            }
            if ("check".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)CRMIReleaseVersionBehaviorCodes.CHECK);
            }
            if ("force".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)CRMIReleaseVersionBehaviorCodes.FORCE);
            }
            throw new FHIRException("Unknown CRMIReleaseVersionBehaviorCodes code '" + codeString + "'");
        }

        public String toCode(CRMIReleaseVersionBehaviorCodes code) {
            if (code == CRMIReleaseVersionBehaviorCodes.DEFAULT) {
                return "error";
            }
            if (code == CRMIReleaseVersionBehaviorCodes.CHECK) {
                return "check";
            }
            if (code == CRMIReleaseVersionBehaviorCodes.FORCE) {
                return "force";
            }
            return "?";
        }

        public String toSystem(CRMIReleaseVersionBehaviorCodes code) {
            return code.getSystem();
        }
    }

    public static enum CRMIReleaseVersionBehaviorCodes {
        DEFAULT,
        CHECK,
        FORCE,
        NULL;


        public static CRMIReleaseVersionBehaviorCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("default".equals(codeString)) {
                return DEFAULT;
            }
            if ("check".equals(codeString)) {
                return CHECK;
            }
            if ("force".equals(codeString)) {
                return FORCE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CRMIReleaseVersionBehaviorCodes '" + codeString + "'");
        }

        public String toCode() {
            switch (this.ordinal()) {
                case 0: {
                    return "default";
                }
                case 1: {
                    return "check";
                }
                case 2: {
                    return "force";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this.ordinal()) {
                case 0: {
                    return "http://hl7.org/fhir/uv/crmi/ValueSet/crmi-release-version-behavior";
                }
                case 1: {
                    return "http://hl7.org/fhir/uv/crmi/ValueSet/crmi-release-version-behavior";
                }
                case 2: {
                    return "http://hl7.org/fhir/uv/crmi/ValueSet/crmi-release-version-behavior";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this.ordinal()) {
                case 0: {
                    return "The version provided will be applied to the root artifact and all owned components if a version is not specified.";
                }
                case 1: {
                    return "If the root artifact has a specified version different from the version passed to the operation, an error will be returned.";
                }
                case 2: {
                    return "The version provided will be applied to the root artifact and all owned components, regardless of whether or not a version was already specified.";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this.ordinal()) {
                case 0: {
                    return "Default";
                }
                case 1: {
                    return "Check";
                }
                case 2: {
                    return "Force";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }
    }
}

