/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.r4;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Resource;

public class ContainedHelper {
    private ContainedHelper() {
    }

    public static DomainResource liftContainedResourcesToParent(DomainResource resource) {
        ContainedHelper.getContainedResourcesInContainedResources((Resource)resource).forEach(arg_0 -> ((DomainResource)resource).addContained(arg_0));
        return resource;
    }

    private static List<Resource> getContainedResourcesInContainedResources(Resource resource) {
        if (!(resource instanceof DomainResource)) {
            return new ArrayList<Resource>();
        }
        return ContainedHelper.streamContainedResourcesInContainedResources(resource).collect(Collectors.toList());
    }

    public static List<Resource> getAllContainedResources(Resource resource) {
        if (!(resource instanceof DomainResource)) {
            return new ArrayList<Resource>();
        }
        return ContainedHelper.streamAllContainedResources(resource).collect(Collectors.toList());
    }

    private static Stream<Resource> streamContainedResourcesInContainedResources(Resource resource) {
        if (!(resource instanceof DomainResource)) {
            return Stream.empty();
        }
        return ((DomainResource)resource).getContained().stream().flatMap(ContainedHelper::streamAllContainedResources);
    }

    private static Stream<Resource> streamAllContainedResources(Resource resource) {
        if (!(resource instanceof DomainResource)) {
            return Stream.empty();
        }
        List contained = ((DomainResource)resource).getContained();
        return Stream.concat(contained.stream(), contained.stream().flatMap(ContainedHelper::streamAllContainedResources));
    }
}

