/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.r5;

import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.PrimitiveType;

public class CRMIReleaseExperimentalBehavior {

    public static class CRMIReleaseExperimentalBehaviorCodesEnumFactory
    implements EnumFactory<CRMIReleaseExperimentalBehaviorCodes> {
        public CRMIReleaseExperimentalBehaviorCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("error".equals(codeString)) {
                return CRMIReleaseExperimentalBehaviorCodes.ERROR;
            }
            if ("warn".equals(codeString)) {
                return CRMIReleaseExperimentalBehaviorCodes.WARN;
            }
            if ("none".equals(codeString)) {
                return CRMIReleaseExperimentalBehaviorCodes.NONE;
            }
            throw new IllegalArgumentException("Unknown CRMIReleaseExperimentalBehaviorCodes code '" + codeString + "'");
        }

        public Enumeration<CRMIReleaseExperimentalBehaviorCodes> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration((EnumFactory)this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("error".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)CRMIReleaseExperimentalBehaviorCodes.ERROR);
            }
            if ("warn".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)CRMIReleaseExperimentalBehaviorCodes.WARN);
            }
            if ("none".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)CRMIReleaseExperimentalBehaviorCodes.NONE);
            }
            throw new FHIRException("Unknown CRMIReleaseExperimentalBehaviorCodes code '" + codeString + "'");
        }

        public String toCode(CRMIReleaseExperimentalBehaviorCodes code) {
            if (code == CRMIReleaseExperimentalBehaviorCodes.ERROR) {
                return "error";
            }
            if (code == CRMIReleaseExperimentalBehaviorCodes.WARN) {
                return "warn";
            }
            if (code == CRMIReleaseExperimentalBehaviorCodes.NONE) {
                return "none";
            }
            return "?";
        }

        public String toSystem(CRMIReleaseExperimentalBehaviorCodes code) {
            return code.getSystem();
        }
    }

    public static enum CRMIReleaseExperimentalBehaviorCodes {
        ERROR,
        WARN,
        NONE,
        NULL;


        public static CRMIReleaseExperimentalBehaviorCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("warn".equals(codeString)) {
                return WARN;
            }
            if ("none".equals(codeString)) {
                return NONE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CRMIReleaseExperimentalBehaviorCode '" + codeString + "'");
        }

        public String toCode() {
            switch (this.ordinal()) {
                case 0: {
                    return "error";
                }
                case 1: {
                    return "warn";
                }
                case 2: {
                    return "none";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this.ordinal()) {
                case 0: {
                    return "http://hl7.org/fhir/uv/crmi/CodeSystem/crmi-release-experimental-behavior-codes";
                }
                case 1: {
                    return "http://hl7.org/fhir/uv/crmi/CodeSystem/crmi-release-experimental-behavior-codes";
                }
                case 2: {
                    return "http://hl7.org/fhir/uv/crmi/CodeSystem/crmi-release-experimental-behavior-codes";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this.ordinal()) {
                case 0: {
                    return "The repository should throw an error if a specification which is not Experimental references Experimental components.";
                }
                case 1: {
                    return "The repository should warn if a specification which is not Experimental references Experimental components.";
                }
                case 2: {
                    return "The repository does not need to consider the state of Experimental.";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this.ordinal()) {
                case 0: {
                    return "Error";
                }
                case 1: {
                    return "Warn";
                }
                case 2: {
                    return "None";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }
    }
}

