/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.r5;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UuidType;
import org.opencds.cqf.fhir.utility.Ids;

public class Parameters {
    private Parameters() {
    }

    public static org.hl7.fhir.r5.model.Parameters parameters(IdType id, Parameters.ParametersParameterComponent ... parts) {
        Preconditions.checkNotNull((Object)id);
        org.hl7.fhir.r5.model.Parameters p = Parameters.parameters(parts);
        p.setId((IIdType)id);
        return p;
    }

    public static org.hl7.fhir.r5.model.Parameters parameters(String idPart, Parameters.ParametersParameterComponent ... parts) {
        Preconditions.checkNotNull((Object)idPart);
        return Parameters.parameters((IdType)Ids.newId(org.hl7.fhir.r5.model.Parameters.class, idPart), parts);
    }

    public static org.hl7.fhir.r5.model.Parameters parameters(Parameters.ParametersParameterComponent ... parts) {
        org.hl7.fhir.r5.model.Parameters p = new org.hl7.fhir.r5.model.Parameters();
        for (Parameters.ParametersParameterComponent c : parts) {
            p.addParameter(c);
        }
        return p;
    }

    public static Parameters.ParametersParameterComponent part(String name, Parameters.ParametersParameterComponent ... parts) {
        Preconditions.checkNotNull((Object)name);
        Parameters.ParametersParameterComponent c = new Parameters.ParametersParameterComponent();
        c.setName(name);
        for (Parameters.ParametersParameterComponent p : parts) {
            c.addPart(p);
        }
        return c;
    }

    public static Parameters.ParametersParameterComponent part(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        Parameters.ParametersParameterComponent c = Parameters.part(name, parts);
        c.setValue((DataType)new StringType(value));
        return c;
    }

    public static Parameters.ParametersParameterComponent part(String name, DataType value, Parameters.ParametersParameterComponent ... parts) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        Parameters.ParametersParameterComponent c = Parameters.part(name, parts);
        c.setValue(value);
        return c;
    }

    public static Parameters.ParametersParameterComponent part(String name, Resource resource, Parameters.ParametersParameterComponent ... parts) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)resource);
        Parameters.ParametersParameterComponent c = Parameters.part(name, parts);
        c.setResource(resource);
        return c;
    }

    public static List<Parameters.ParametersParameterComponent> getPartsByName(org.hl7.fhir.r5.model.Parameters parameters, String name) {
        Preconditions.checkNotNull((Object)parameters);
        Preconditions.checkNotNull((Object)name);
        return parameters.getParameter().stream().filter(x -> name.equals(x.getName())).collect(Collectors.toList());
    }

    public static Parameters.ParametersParameterComponent base64BinaryPart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new Base64BinaryType(value), parts);
    }

    public static Parameters.ParametersParameterComponent booleanPart(String name, boolean value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new BooleanType(value), parts);
    }

    public static Parameters.ParametersParameterComponent canonicalPart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new CanonicalType(value), parts);
    }

    public static Parameters.ParametersParameterComponent codePart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new CodeType(value), parts);
    }

    public static Parameters.ParametersParameterComponent datePart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new DateType(value), parts);
    }

    public static Parameters.ParametersParameterComponent dateTimePart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new DateTimeType(value), parts);
    }

    public static Parameters.ParametersParameterComponent decimalPart(String name, double value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new DecimalType(value), parts);
    }

    public static Parameters.ParametersParameterComponent idPart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new IdType(value), parts);
    }

    public static Parameters.ParametersParameterComponent instantPart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new InstantType(value), parts);
    }

    public static Parameters.ParametersParameterComponent integerPart(String name, int value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new IntegerType(value), parts);
    }

    public static Parameters.ParametersParameterComponent integer64Part(String name, long value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new Integer64Type(value), parts);
    }

    public static Parameters.ParametersParameterComponent markdownPart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new MarkdownType(value), parts);
    }

    public static Parameters.ParametersParameterComponent oidPart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new OidType(value), parts);
    }

    public static Parameters.ParametersParameterComponent positiveIntPart(String name, int value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new PositiveIntType(value), parts);
    }

    public static Parameters.ParametersParameterComponent stringPart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new StringType(value), parts);
    }

    public static Parameters.ParametersParameterComponent timePart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new TimeType(value), parts);
    }

    public static Parameters.ParametersParameterComponent unsignedIntPart(String name, int value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new UnsignedIntType(value), parts);
    }

    public static Parameters.ParametersParameterComponent uriPart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new UriType(value), parts);
    }

    public static Parameters.ParametersParameterComponent urlPart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new UrlType(value), parts);
    }

    public static Parameters.ParametersParameterComponent uuidPart(String name, String value, Parameters.ParametersParameterComponent ... parts) {
        return Parameters.part(name, (DataType)new UuidType(value), parts);
    }
}

