/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository.ig;

import com.google.common.io.Files;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Enumerations;
import org.opencds.cqf.fhir.utility.repository.ig.IgRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IgConventions {
    public static final IgConventions FLAT = new IgConventions(FhirTypeLayout.FLAT, CategoryLayout.FLAT, FilenameMode.TYPE_AND_ID);
    public static final IgConventions STANDARD = new IgConventions(FhirTypeLayout.DIRECTORY_PER_TYPE, CategoryLayout.DIRECTORY_PER_CATEGORY, FilenameMode.ID_ONLY);
    private static final Logger LOG = LoggerFactory.getLogger(IgConventions.class);
    private final FhirTypeLayout typeLayout;
    private final CategoryLayout categoryLayout;
    private final FilenameMode filenameMode;

    public IgConventions(FhirTypeLayout typeLayout, CategoryLayout categoryLayout, FilenameMode filenameMode) {
        this.typeLayout = typeLayout;
        this.categoryLayout = categoryLayout;
        this.filenameMode = filenameMode;
    }

    FhirTypeLayout typeLayout() {
        return this.typeLayout;
    }

    CategoryLayout categoryLayout() {
        return this.categoryLayout;
    }

    FilenameMode filenameMode() {
        return this.filenameMode;
    }

    public static IgConventions autoDetect(Path path) {
        if (path == null || !path.toFile().exists()) {
            return STANDARD;
        }
        Path categoryPath = Stream.of("tests", "vocabulary", "resources").map(path::resolve).filter(x -> x.toFile().exists()).findFirst().orElse(path);
        boolean hasCategoryDirectory = !path.equals(categoryPath);
        Path typePath = Stream.of(Enumerations.FHIRAllTypes.values()).map(Enum::name).map(String::toLowerCase).map(categoryPath::resolve).filter(x -> x.toFile().exists()).findFirst().orElse(categoryPath);
        boolean hasTypeDirectory = !categoryPath.equals(typePath);
        FilenameFilter resourceFileFilter = (dir, name) -> name.contains(".") && IgRepository.FILE_EXTENSIONS.containsValue((Object)name.toLowerCase().substring(name.lastIndexOf(46) + 1));
        File[] potentialResourceFiles = typePath.toFile().listFiles(resourceFileFilter);
        boolean hasTypeFilename = Stream.of(potentialResourceFiles).filter(file -> IgConventions.claimedFhirType(file) != Enumerations.FHIRAllTypes.NULL).anyMatch(file -> IgConventions.contentsMatchClaimedType(file, IgConventions.claimedFhirType(file)));
        IgConventions config = new IgConventions(hasTypeDirectory ? FhirTypeLayout.DIRECTORY_PER_TYPE : FhirTypeLayout.FLAT, hasCategoryDirectory ? CategoryLayout.DIRECTORY_PER_CATEGORY : CategoryLayout.FLAT, hasTypeFilename ? FilenameMode.TYPE_AND_ID : FilenameMode.ID_ONLY);
        LOG.info("Auto-detected repository configuration: {}", (Object)config);
        return config;
    }

    private static boolean contentsMatchClaimedType(File file, Enumerations.FHIRAllTypes claimedFhirType) {
        Objects.requireNonNull(file);
        Objects.requireNonNull(claimedFhirType);
        try {
            String contents = Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).read();
            if (contents == null || contents.isEmpty()) {
                return false;
            }
            return contents.toUpperCase().contains(String.format("\"RESOURCETYPE\": \"%s\"", claimedFhirType.name()));
        }
        catch (IOException e) {
            return false;
        }
    }

    private static Enumerations.FHIRAllTypes claimedFhirType(File file) {
        String filename = file.getName();
        if (!filename.contains("-")) {
            return Enumerations.FHIRAllTypes.NULL;
        }
        String codeName = filename.substring(0, filename.indexOf("-")).toUpperCase();
        try {
            return Enumerations.FHIRAllTypes.valueOf((String)codeName);
        }
        catch (Exception e) {
            return Enumerations.FHIRAllTypes.NULL;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typeLayout == null ? 0 : this.typeLayout.hashCode());
        result = 31 * result + (this.categoryLayout == null ? 0 : this.categoryLayout.hashCode());
        result = 31 * result + (this.filenameMode == null ? 0 : this.filenameMode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IgConventions other = (IgConventions)obj;
        if (this.typeLayout != other.typeLayout) {
            return false;
        }
        if (this.categoryLayout != other.categoryLayout) {
            return false;
        }
        return this.filenameMode == other.filenameMode;
    }

    public String toString() {
        return String.format("IGConventions [typeLayout=%s, categoryLayout=%s, filenameMode=%s]", new Object[]{this.typeLayout, this.categoryLayout, this.filenameMode});
    }

    public static enum FhirTypeLayout {
        DIRECTORY_PER_TYPE,
        FLAT;

    }

    public static enum CategoryLayout {
        DIRECTORY_PER_CATEGORY,
        FLAT;

    }

    public static enum FilenameMode {
        TYPE_AND_ID,
        ID_ONLY;

    }
}

