/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository.operations;

import ca.uhn.fhir.context.FhirContext;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.monad.Eithers;
import org.opencds.cqf.fhir.utility.repository.operations.IActivityDefinitionProcessor;
import org.opencds.cqf.fhir.utility.repository.operations.IActivityDefinitionProcessorFactory;
import org.opencds.cqf.fhir.utility.repository.operations.IPlanDefinitionProcessor;
import org.opencds.cqf.fhir.utility.repository.operations.IPlanDefinitionProcessorFactory;
import org.opencds.cqf.fhir.utility.repository.operations.IQuestionnaireProcessor;
import org.opencds.cqf.fhir.utility.repository.operations.IQuestionnaireProcessorFactory;
import org.opencds.cqf.fhir.utility.repository.operations.IQuestionnaireResponseProcessor;
import org.opencds.cqf.fhir.utility.repository.operations.IQuestionnaireResponseProcessorFactory;
import org.opencds.cqf.fhir.utility.repository.operations.IRepositoryOperationProvider;
import org.opencds.cqf.fhir.utility.repository.operations.OperationParametersParser;

public class RepositoryOperationProvider
implements IRepositoryOperationProvider {
    private final String noFactoryError = "No factory exists for (%s), unable to invoke operation (%s)";
    private final String unSupportedOpError = "(%s) operation not supported for type (%s)";
    private final String activityDef = "ActivityDefinition";
    private final String planDef = "PlanDefinition";
    private final String questionnaire = "Questionnaire";
    private final String questionnaireResponse = "QuestionnaireResponse";
    private final FhirContext fhirContext;
    private final OperationParametersParser operationParametersParser;
    private final IActivityDefinitionProcessorFactory activityDefinitionProcessorFactory;
    private final IPlanDefinitionProcessorFactory planDefinitionProcessorFactory;
    private final IQuestionnaireProcessorFactory questionnaireProcessorFactory;
    private final IQuestionnaireResponseProcessorFactory questionnaireResponseProcessorFactory;

    public RepositoryOperationProvider(FhirContext fhirContext, IActivityDefinitionProcessorFactory activityDefinitionProcessorFactory, IPlanDefinitionProcessorFactory planDefinitionProcessorFactory, IQuestionnaireProcessorFactory questionnaireProcessorFactory, IQuestionnaireResponseProcessorFactory questionnaireResponseProcessorFactory) {
        this.fhirContext = fhirContext;
        this.operationParametersParser = new OperationParametersParser(AdapterFactory.forFhirVersion(this.fhirContext.getVersion().getVersion()));
        this.activityDefinitionProcessorFactory = activityDefinitionProcessorFactory;
        this.planDefinitionProcessorFactory = planDefinitionProcessorFactory;
        this.questionnaireProcessorFactory = questionnaireProcessorFactory;
        this.questionnaireResponseProcessorFactory = questionnaireResponseProcessorFactory;
    }

    @Override
    public <C extends IPrimitiveType<String>, R extends IBaseResource> R invokeOperation(Repository repository, IIdType id, String resourceType, String operationName, IBaseParameters parameters) {
        Objects.requireNonNull(repository);
        Map<String, Object> paramMap = this.operationParametersParser.getParameterParts(parameters);
        switch (resourceType) {
            case "ActivityDefinition": {
                return this.invokeActivityDefinition(repository, id, operationName, paramMap);
            }
        }
        return null;
    }

    protected <C extends IPrimitiveType<String>, R extends IBaseResource> R invokeActivityDefinition(Repository repository, IIdType id, String operationName, Map<String, Object> paramMap) {
        if (this.activityDefinitionProcessorFactory == null) {
            throw new IllegalArgumentException(String.format("No factory exists for (%s), unable to invoke operation (%s)", "ActivityDefinition", operationName));
        }
        IActivityDefinitionProcessor processor = this.activityDefinitionProcessorFactory.create(repository);
        switch (operationName) {
            case "$apply": {
                Either3<IPrimitiveType, IIdType, IBaseResource> activityDefinition = Eithers.for3((IPrimitiveType)paramMap.get("canonical"), id, (IBaseResource)paramMap.get("activityDefinition"));
                String subject = (String)((IPrimitiveType)paramMap.get("subject")).getValue();
                IPrimitiveType encounter = (IPrimitiveType)paramMap.get("encounter");
                IPrimitiveType practitioner = (IPrimitiveType)paramMap.get("practitioner");
                IPrimitiveType organization = (IPrimitiveType)paramMap.get("organization");
                return (R)processor.apply(activityDefinition, subject, encounter == null ? null : (String)encounter.getValue(), practitioner == null ? null : (String)practitioner.getValue(), organization == null ? null : (String)organization.getValue(), (IBaseDatatype)paramMap.get("userType"), (IBaseDatatype)paramMap.get("userLanguage"), (IBaseDatatype)paramMap.get("userTaskContext"), (IBaseDatatype)paramMap.get("setting"), (IBaseDatatype)paramMap.get("settingContext"), (IBaseParameters)paramMap.get("parameters"), (Boolean)paramMap.get("useServerData"), (IBaseBundle)paramMap.get("data"), (IBaseResource)paramMap.get("dataEndpoint"), (IBaseResource)paramMap.get("contentEndpoint"), (IBaseResource)paramMap.get("terminologyEndpoint"));
            }
        }
        throw new IllegalArgumentException(String.format("(%s) operation not supported for type (%s)", operationName, "ActivityDefinition"));
    }

    protected <C extends IPrimitiveType<String>, R extends IBaseResource> R invokePlanDefinition(Repository repository, IIdType id, String operationName, Map<String, Object> paramMap) {
        if (this.planDefinitionProcessorFactory == null) {
            throw new IllegalArgumentException(String.format("No factory exists for (%s), unable to invoke operation (%s)", "PlanDefinition", operationName));
        }
        IPlanDefinitionProcessor processor = this.planDefinitionProcessorFactory.create(repository);
        switch (operationName) {
            case "$apply": 
            case "$r5.apply": {
                Either3<IPrimitiveType, IIdType, IBaseResource> planDefinition = Eithers.for3((IPrimitiveType)paramMap.get("canonical"), id, (IBaseResource)paramMap.get("planDefinition"));
                String subject = (String)((IPrimitiveType)paramMap.get("subject")).getValue();
                Optional<IPrimitiveType> encounterParam = Optional.of((IPrimitiveType)paramMap.get("encounter"));
                String encounter = encounterParam.isPresent() ? (String)encounterParam.get().getValue() : null;
                Optional<IPrimitiveType> practitionerParam = Optional.of((IPrimitiveType)paramMap.get("practitioner"));
                String practitioner = practitionerParam.isPresent() ? (String)practitionerParam.get().getValue() : null;
                Optional<IPrimitiveType> organizationParam = Optional.of((IPrimitiveType)paramMap.get("organization"));
                String organization = organizationParam.isPresent() ? (String)organizationParam.get().getValue() : null;
                IBaseDatatype userType = (IBaseDatatype)paramMap.get("userType");
                IBaseDatatype userLanguage = (IBaseDatatype)paramMap.get("userLanguage");
                IBaseDatatype userTaskContext = (IBaseDatatype)paramMap.get("userTaskContext");
                IBaseDatatype setting = (IBaseDatatype)paramMap.get("setting");
                IBaseDatatype settingContext = (IBaseDatatype)paramMap.get("settingContext");
                IBaseParameters parameters = (IBaseParameters)paramMap.get("parameters");
                Boolean useServerData = (Boolean)paramMap.get("useServerData");
                IBaseBundle data = (IBaseBundle)paramMap.get("data");
                IBaseResource dataEndpoint = (IBaseResource)paramMap.get("dataEndpoint");
                IBaseResource contentEndpoint = (IBaseResource)paramMap.get("contentEndpoint");
                IBaseResource terminologyEndpoint = (IBaseResource)paramMap.get("terminologyEndpoint");
                if (operationName.equals("$r5.apply)")) {
                    return (R)processor.applyR5(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, data, dataEndpoint, contentEndpoint, terminologyEndpoint);
                }
                return (R)processor.apply(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, data, dataEndpoint, contentEndpoint, terminologyEndpoint);
            }
        }
        throw new IllegalArgumentException(String.format("(%s) operation not supported for type (%s)", operationName, "PlanDefinition"));
    }

    protected <C extends IPrimitiveType<String>, R extends IBaseResource> R invokeQuestionnaire(Repository repository, IIdType id, String operationName, Map<String, Object> paramMap) {
        if (this.questionnaireProcessorFactory == null) {
            throw new IllegalArgumentException(String.format("No factory exists for (%s), unable to invoke operation (%s)", "Questionnaire", operationName));
        }
        IQuestionnaireProcessor processor = this.questionnaireProcessorFactory.create(repository);
        switch (operationName) {
            default: 
        }
        throw new IllegalArgumentException(String.format("(%s) operation not supported for type (%s)", operationName, "Questionnaire"));
    }

    protected <C extends IPrimitiveType<String>, R extends IBaseResource> R invokeQuestionnaireResponse(Repository repository, IIdType id, String operationName, Map<String, Object> paramMap) {
        if (this.questionnaireResponseProcessorFactory == null) {
            throw new IllegalArgumentException(String.format("No factory exists for (%s), unable to invoke operation (%s)", "QuestionnaireResponse", operationName));
        }
        IQuestionnaireResponseProcessor processor = this.questionnaireResponseProcessorFactory.create(repository);
        switch (operationName) {
            default: 
        }
        throw new IllegalArgumentException(String.format("(%s) operation not supported for type (%s)", operationName, "QuestionnaireResponse"));
    }
}

