/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.MetadataResource;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;

public class VisitorHelper {
    public static <T extends IBaseDatatype> Optional<T> getParameter(String name, IBaseParameters operationParameters, Class<T> type) {
        AdapterFactory factory = AdapterFactory.forFhirVersion(operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(p -> factory.createParameters((IBaseParameters)p)).map(p -> p.getParameter(name)).map(p -> factory.createParametersParameters((IBaseBackboneElement)p)).map(parametersParameters -> parametersParameters.getValue());
    }

    public static <T extends IBaseResource> Optional<T> getResourceParameter(String name, IBaseParameters operationParameters, Class<T> type) {
        AdapterFactory factory = AdapterFactory.forFhirVersion(operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(p -> factory.createParameters((IBaseParameters)p)).map(p -> p.getParameter(name)).map(p -> factory.createParametersParameters((IBaseBackboneElement)p)).map(parametersParameters -> parametersParameters.getResource());
    }

    public static <T extends IBaseDatatype> Optional<List<T>> getListParameter(String name, IBaseParameters operationParameters, Class<T> type) {
        AdapterFactory factory = AdapterFactory.forFhirVersion(operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(p -> factory.createParameters((IBaseParameters)p)).map(p -> p.getParameterValues(name)).map(vals -> vals.stream().map(val -> val).collect(Collectors.toList()));
    }

    public static List<IBaseResource> getMetadataResourcesFromBundle(IBaseBundle bundle) {
        ArrayList<IBaseResource> resourceList = new ArrayList<IBaseResource>();
        FhirVersionEnum version = bundle.getStructureFhirVersionEnum();
        if (!BundleHelper.getEntryFirstRep(bundle).isEmpty()) {
            BundleHelper.getEntry(bundle).stream().map(e -> BundleHelper.getEntryResource(version, e)).filter(r -> r != null).forEach(r -> {
                switch (version) {
                    case DSTU3: {
                        if (!(r instanceof org.hl7.fhir.dstu3.model.MetadataResource)) break;
                        resourceList.add((IBaseResource)r);
                        break;
                    }
                    case R4: {
                        if (!(r instanceof MetadataResource)) break;
                        resourceList.add((IBaseResource)r);
                        break;
                    }
                    case R5: {
                        if (!(r instanceof org.hl7.fhir.r5.model.MetadataResource)) break;
                        resourceList.add((IBaseResource)r);
                        break;
                    }
                }
            });
        }
        return resourceList;
    }
}

