/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor.r5;

import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;

public class KnowledgeArtifactApproveVisitor {
    public static ArtifactAssessment createApprovalAssessment(IIdType id, String artifactAssessmentType, Optional<MarkdownType> artifactAssessmentSummary, Optional<CanonicalType> artifactAssessmentTargetCanonical, Optional<CanonicalType> artifactAssessmentRelatedArtifact, Optional<Reference> artifactAssessmentAuthor, Reference artifactTargetReference) throws UnprocessableEntityException {
        ArtifactAssessment artifactAssessment;
        try {
            artifactAssessment = new ArtifactAssessment((DataType)new Reference(id));
            artifactAssessment.setDate(new Date());
            ArtifactAssessment.ArtifactAssessmentContentComponent content = artifactAssessment.getContentFirstRep();
            if (artifactAssessmentSummary.isPresent()) {
                content.setSummaryElement(artifactAssessmentSummary.get());
            }
            if (artifactAssessmentAuthor.isPresent()) {
                content.setAuthor(artifactAssessmentAuthor.get());
            }
            if (StringUtils.isNotBlank((CharSequence)artifactAssessmentType)) {
                content.setInformationType(ArtifactAssessment.ArtifactAssessmentInformationType.fromCode((String)artifactAssessmentType));
            }
            if (artifactAssessmentTargetCanonical.isPresent()) {
                content.addRelatedArtifact().setType(RelatedArtifact.RelatedArtifactType.DERIVEDFROM).setResourceElement(artifactAssessmentTargetCanonical.get());
            }
            if (artifactAssessmentRelatedArtifact.isPresent()) {
                content.addRelatedArtifact().setType(RelatedArtifact.RelatedArtifactType.CITATION).setResourceElement(artifactAssessmentRelatedArtifact.get());
            }
        }
        catch (FHIRException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
        return artifactAssessment;
    }
}

