/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor.r5;

import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.UsageContext;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.SearchHelper;

public class KnowledgeArtifactDraftVisitor {
    public static Optional<MetadataResource> processReferencedResourceForDraft(Repository repository, RelatedArtifact ra, String version) {
        Bundle.BundleEntryComponent referencedResourceEntry;
        Bundle referencedResourceBundle;
        Optional<MetadataResource> referencedResource = Optional.empty();
        if (ra.hasResource() && !(referencedResourceBundle = (Bundle)SearchHelper.searchRepositoryByCanonicalWithPaging(repository, ra.getResourceElement())).getEntryFirstRep().isEmpty() && (referencedResourceEntry = referencedResourceBundle.getEntryFirstRep()).hasResource() && referencedResourceEntry.getResource() instanceof MetadataResource) {
            referencedResource = Optional.of((MetadataResource)referencedResourceEntry.getResource());
        }
        return referencedResource;
    }

    public static void updateUsageContextReferencesWithUrns(MetadataResource newResource, List<MetadataResource> resourceListWithOriginalIds, List<IdType> idListForTransactionBundle) {
        List useContexts = newResource.getUseContext();
        for (UsageContext useContext : useContexts) {
            Reference useContextRef;
            if (!useContext.hasValueReference() || (useContextRef = useContext.getValueReference()) == null) continue;
            resourceListWithOriginalIds.stream().filter(resource -> (resource.getClass().getSimpleName() + "/" + resource.getIdElement().getIdPart()).equals(useContextRef.getReference())).findAny().ifPresent(resource -> {
                int indexOfDraftInIdList = resourceListWithOriginalIds.indexOf(resource);
                useContext.setValue((DataType)new Reference((IIdType)idListForTransactionBundle.get(indexOfDraftInIdList)));
            });
        }
    }
}

