/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opendatadiscovery.client.model.DataQualityTestExpectation;
import org.opendatadiscovery.client.model.LinkedUrl;

@JsonPropertyOrder(value={"suite_name", "dataset_list", "expectation", "suite_url", "linked_url_list"})
@JsonTypeName(value="DataQualityTest")
public class DataQualityTest {
    public static final String JSON_PROPERTY_SUITE_NAME = "suite_name";
    private String suiteName;
    public static final String JSON_PROPERTY_DATASET_LIST = "dataset_list";
    private List<String> datasetList = new ArrayList<String>();
    public static final String JSON_PROPERTY_EXPECTATION = "expectation";
    private DataQualityTestExpectation expectation;
    public static final String JSON_PROPERTY_SUITE_URL = "suite_url";
    private String suiteUrl;
    public static final String JSON_PROPERTY_LINKED_URL_LIST = "linked_url_list";
    private List<LinkedUrl> linkedUrlList = null;

    public DataQualityTest suiteName(String suiteName) {
        this.suiteName = suiteName;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="suite_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSuiteName() {
        return this.suiteName;
    }

    @JsonProperty(value="suite_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public DataQualityTest datasetList(List<String> datasetList) {
        this.datasetList = datasetList;
        return this;
    }

    public DataQualityTest addDatasetListItem(String datasetListItem) {
        this.datasetList.add(datasetListItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="dataset_list")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getDatasetList() {
        return this.datasetList;
    }

    @JsonProperty(value="dataset_list")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDatasetList(List<String> datasetList) {
        this.datasetList = datasetList;
    }

    public DataQualityTest expectation(DataQualityTestExpectation expectation) {
        this.expectation = expectation;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="expectation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DataQualityTestExpectation getExpectation() {
        return this.expectation;
    }

    @JsonProperty(value="expectation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpectation(DataQualityTestExpectation expectation) {
        this.expectation = expectation;
    }

    public DataQualityTest suiteUrl(String suiteUrl) {
        this.suiteUrl = suiteUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="suite_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSuiteUrl() {
        return this.suiteUrl;
    }

    @JsonProperty(value="suite_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuiteUrl(String suiteUrl) {
        this.suiteUrl = suiteUrl;
    }

    public DataQualityTest linkedUrlList(List<LinkedUrl> linkedUrlList) {
        this.linkedUrlList = linkedUrlList;
        return this;
    }

    public DataQualityTest addLinkedUrlListItem(LinkedUrl linkedUrlListItem) {
        if (this.linkedUrlList == null) {
            this.linkedUrlList = new ArrayList<LinkedUrl>();
        }
        this.linkedUrlList.add(linkedUrlListItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="linked_url_list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LinkedUrl> getLinkedUrlList() {
        return this.linkedUrlList;
    }

    @JsonProperty(value="linked_url_list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinkedUrlList(List<LinkedUrl> linkedUrlList) {
        this.linkedUrlList = linkedUrlList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataQualityTest dataQualityTest = (DataQualityTest)o;
        return Objects.equals(this.suiteName, dataQualityTest.suiteName) && Objects.equals(this.datasetList, dataQualityTest.datasetList) && Objects.equals(this.expectation, dataQualityTest.expectation) && Objects.equals(this.suiteUrl, dataQualityTest.suiteUrl) && Objects.equals(this.linkedUrlList, dataQualityTest.linkedUrlList);
    }

    public int hashCode() {
        return Objects.hash(this.suiteName, this.datasetList, this.expectation, this.suiteUrl, this.linkedUrlList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataQualityTest {\n");
        sb.append("    suiteName: ").append(this.toIndentedString(this.suiteName)).append("\n");
        sb.append("    datasetList: ").append(this.toIndentedString(this.datasetList)).append("\n");
        sb.append("    expectation: ").append(this.toIndentedString(this.expectation)).append("\n");
        sb.append("    suiteUrl: ").append(this.toIndentedString(this.suiteUrl)).append("\n");
        sb.append("    linkedUrlList: ").append(this.toIndentedString(this.linkedUrlList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

