/*
 * Decompiled with CFR 0.152.
 */
package org.openengsb.connector.email.internal;

import org.apache.commons.lang.StringUtils;
import org.openengsb.connector.email.internal.abstraction.MailAbstraction;
import org.openengsb.connector.email.internal.abstraction.MailProperties;
import org.openengsb.core.api.AliveState;
import org.openengsb.core.common.AbstractOpenEngSBService;
import org.openengsb.domain.notification.NotificationDomain;
import org.openengsb.domain.notification.model.Notification;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailNotifier
extends AbstractOpenEngSBService
implements NotificationDomain {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailNotifier.class);
    private final MailAbstraction mailAbstraction;
    private ServiceRegistration serviceRegistration;
    private MailProperties properties;

    public EmailNotifier(String instanceId, MailAbstraction mailAbstraction) {
        super(instanceId);
        this.mailAbstraction = mailAbstraction;
    }

    public void notify(Notification notification) {
        LOGGER.info("notifying {} via email...", (Object)notification.getRecipient());
        LOGGER.info("Subject: {}", (Object)notification.getSubject());
        LOGGER.info("Message: {}", (Object)StringUtils.abbreviate((String)notification.getMessage(), (int)200));
        this.mailAbstraction.send(this.properties, notification.getSubject(), notification.getMessage(), notification.getRecipient());
        LOGGER.info("mail has been sent");
    }

    public AliveState getAliveState() {
        AliveState aliveState = this.mailAbstraction.getAliveState();
        if (aliveState == null) {
            return AliveState.OFFLINE;
        }
        return aliveState;
    }

    public ServiceRegistration getServiceRegistration() {
        return this.serviceRegistration;
    }

    public void setServiceRegistration(ServiceRegistration serviceRegistration) {
        this.serviceRegistration = serviceRegistration;
    }

    public MailProperties getProperties() {
        return this.properties;
    }

    public void createProperties() {
        this.properties = this.mailAbstraction.createMailProperties();
    }
}

