/*
 * Decompiled with CFR 0.152.
 */
package org.openengsb.connector.email.internal.abstraction;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openengsb.connector.email.internal.abstraction.MailAbstraction;
import org.openengsb.connector.email.internal.abstraction.MailProperties;
import org.openengsb.core.api.AliveState;
import org.openengsb.core.api.DomainMethodExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaxMailAbstraction
implements MailAbstraction {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaxMailAbstraction.class);
    private AliveState aliveState = AliveState.OFFLINE;
    private SessionManager sessionManager = new SessionManager();

    private Session getSession(MailPropertiesImp properties) {
        return this.sessionManager.getSession(properties);
    }

    @Override
    public void send(MailProperties properties, String subject, String textContent, String receiver) {
        try {
            if (!(properties instanceof MailPropertiesImp)) {
                throw new RuntimeException("This implementation works only with internal mail properties");
            }
            MailPropertiesImp props = (MailPropertiesImp)properties;
            Session session = this.getSession(props);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(props.getSender()));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)receiver));
            message.setSubject(this.buildSubject(props, subject));
            message.setText(textContent);
            this.send((Message)message, session);
        }
        catch (Exception e) {
            throw new DomainMethodExecutionException((Throwable)e);
        }
    }

    @Override
    public void connect(MailProperties properties) {
        if (!(properties instanceof MailPropertiesImp)) {
            throw new RuntimeException("This implementation works only with internal mail properties");
        }
        Session session = this.getSession((MailPropertiesImp)properties);
        this.getTransport(session);
    }

    public Transport getTransport(Session session) {
        Transport transport = null;
        try {
            transport = session.getTransport("smtp");
            LOGGER.debug("connecting smtp-transport {}", (Object)transport);
            transport.connect();
            this.aliveState = transport.isConnected() ? AliveState.ONLINE : AliveState.OFFLINE;
            LOGGER.debug("State is now {}", (Object)this.aliveState);
        }
        catch (MessagingException e) {
            LOGGER.error("could not connect transport", (Throwable)e);
            this.aliveState = AliveState.OFFLINE;
            throw new DomainMethodExecutionException("Emailnotifier could not connect", (Throwable)e);
        }
        return transport;
    }

    private void send(Message message, Session session) throws MessagingException {
        LOGGER.info("sending email-message");
        message.saveChanges();
        Transport transport = this.getTransport(session);
        transport.sendMessage(message, message.getAllRecipients());
        transport.close();
        LOGGER.info("email has been sent");
    }

    private String buildSubject(MailPropertiesImp properties, String subject) {
        LOGGER.debug("building subject");
        if (properties.getPrefix() == null) {
            return subject;
        }
        return properties.getPrefix() + " " + subject;
    }

    @Override
    public MailProperties createMailProperties() {
        return new MailPropertiesImp();
    }

    @Override
    public AliveState getAliveState() {
        return this.aliveState;
    }

    private static class SessionManager {
        private Session session;
        private MailPropertiesImp properties;

        private SessionManager() {
        }

        public Session getSession(MailPropertiesImp newProperties) {
            if (this.session == null || !newProperties.equals(this.properties)) {
                LOGGER.info("create new mail session");
                this.properties = newProperties;
                this.session = Session.getInstance((Properties)this.properties.getProperties(), (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(SessionManager.this.properties.getUsername(), SessionManager.this.properties.getPassword());
                    }
                });
            }
            return this.session;
        }
    }

    private static class MailPropertiesImp
    implements MailProperties {
        private final Properties properties;
        private String username;
        private String password;
        private String sender;
        private String prefix;
        private MailProperties.SecureMode secureMode = MailProperties.SecureMode.PLAIN;

        MailPropertiesImp() {
            this.properties = new Properties();
            this.properties.setProperty("mail.debug", "true");
            this.properties.setProperty("mail.smtp.timeout", "35000");
        }

        @Override
        public void setSmtpAuth(Boolean smtpAuth) {
            this.properties.setProperty("mail.smtp.auth", String.valueOf(smtpAuth));
        }

        @Override
        public void setSmtpHost(String smtpHost) {
            this.properties.setProperty("mail.smtp.host", smtpHost);
        }

        @Override
        public void setPassword(String password) {
            this.password = password;
        }

        @Override
        public void setUser(String user) {
            this.username = user;
        }

        @Override
        public void setSmtpPort(String smtpPort) {
            this.properties.setProperty("mail.smtp.port", smtpPort);
            this.properties.setProperty("mail.smtp.socketFactory.port", smtpPort);
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public void setSender(String sender) {
            this.sender = sender;
        }

        public String getSender() {
            return this.sender;
        }

        @Override
        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public void setSecureMode(String secureMode) {
            if (MailProperties.SecureMode.SSL.toString().equals(secureMode)) {
                this.secureMode = MailProperties.SecureMode.SSL;
                this.properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            } else if (MailProperties.SecureMode.STARTTLS.toString().equals(secureMode)) {
                this.secureMode = MailProperties.SecureMode.STARTTLS;
                this.properties.put("mail.smtp.starttls.enable", "true");
            } else {
                this.secureMode = MailProperties.SecureMode.PLAIN;
            }
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }
    }
}

