/**
 * Licensed to the Austrian Association for Software Tool Integration (AASTI)
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. The AASTI licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.openengsb.connector.email.internal.abstraction;

public interface MailProperties {
    void setSmtpAuth(Boolean smtpAuth);

    void setSmtpHost(String smtpHost);

    void setPassword(String password);

    void setUser(String user);

    void setSmtpPort(String smtpPort);

    void setSender(String sender);

    void setPrefix(String string);
    
    void setSecureMode(String secureMode);
    
    enum SecureMode {
        PLAIN,
        STARTTLS,
        SSL
    }

}
