/*
 * Decompiled with CFR 0.152.
 */
package org.openengsb.connector.email.internal;

import java.util.Map;
import org.openengsb.connector.email.internal.EmailNotifier;
import org.openengsb.connector.email.internal.abstraction.MailAbstractionFactory;
import org.openengsb.core.api.Connector;
import org.openengsb.core.common.AbstractConnectorInstanceFactory;
import org.openengsb.domain.notification.NotificationDomainEvents;

public class EmailNotifierFactory
extends AbstractConnectorInstanceFactory<EmailNotifier> {
    private MailAbstractionFactory factory;
    private NotificationDomainEvents notificationEvents;

    public Connector createNewInstance(String id) {
        return new EmailNotifier(id, this.factory.newInstance());
    }

    public void doApplyAttributes(EmailNotifier notifier, Map<String, String> attributes) {
        notifier.createProperties();
        if (attributes.containsKey("user")) {
            notifier.getProperties().setUser(attributes.get("user"));
        }
        if (attributes.containsKey("password")) {
            notifier.getProperties().setPassword(attributes.get("password"));
        }
        if (attributes.containsKey("prefix")) {
            notifier.getProperties().setPrefix(attributes.get("prefix"));
        }
        if (attributes.containsKey("smtpAuth")) {
            notifier.getProperties().setSmtpAuth(Boolean.parseBoolean(attributes.get("smtpAuth")));
        }
        if (attributes.containsKey("smtpSender")) {
            notifier.getProperties().setSender(attributes.get("smtpSender"));
        }
        if (attributes.containsKey("smtpHost")) {
            notifier.getProperties().setSmtpHost(attributes.get("smtpHost"));
        }
        if (attributes.containsKey("smtpPort")) {
            notifier.getProperties().setSmtpPort(attributes.get("smtpPort"));
        }
        if (attributes.containsKey("secureMode")) {
            notifier.getProperties().setSecureMode(attributes.get("secureMode"));
        }
    }

    public void setFactory(MailAbstractionFactory factory) {
        this.factory = factory;
    }

    public void setNotificationEvents(NotificationDomainEvents notificationEvents) {
        this.notificationEvents = notificationEvents;
    }
}

