/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.infocard.sts;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.util.Base64;
import org.eclipse.higgins.sts.api.IAppliesTo;
import org.eclipse.higgins.sts.api.IClaim;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IDigitalIdentity;
import org.eclipse.higgins.sts.api.IEndpointReference;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.ILifetime;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.common.RequestSecurityTokenResponse;
import org.eclipse.higgins.sts.server.token.handler.TokenHandler;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.openid4java.OpenIDException;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.infocard.OpenIDTokenType;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.server.IncrementalNonceGenerator;
import org.openid4java.server.JdbcServerAssociationStore;
import org.openid4java.server.NonceGenerator;
import org.openid4java.server.ServerAssociationStore;

public class OpenIDTokenGeneratorHandler
extends TokenHandler {
    private final LogHelper log = new LogHelper(OpenIDTokenGeneratorHandler.class.getName());
    QName qnameIdentityClaimType = new QName(null, "ClaimType");
    QName qnameIdentityClaimURI = new QName(null, "Uri");
    private boolean bConfigured = false;
    private NonceGenerator _nonceGenerator = new IncrementalNonceGenerator();
    private ServerAssociationStore _privateAssociations;
    private String _opEndpoint;
    private Integer _expireIn;

    protected OpenIDTokenGeneratorHandler() {
        this.log.trace((Object)"TokenGeneratorHandler::TokenGeneratorHandler");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) {
        this.log.trace((Object)"TokenGeneratorHandler::initialize");
        String tableName = (String)mapComponentSettings.get("AssocTableName");
        JdbcServerAssociationStore privateAssociations = new JdbcServerAssociationStore(tableName);
        boolean status = true;
        try {
            InitialContext cxt = new InitialContext();
            String dataSourceJndi = (String)mapComponentSettings.get("AssocDataSource");
            DataSource ds = (DataSource)cxt.lookup(dataSourceJndi);
            privateAssociations.setDataSource(ds);
        }
        catch (NamingException e) {
            this.log.error((Object)"Unable to load JNDI data source from context.");
            status = false;
        }
        this._privateAssociations = privateAssociations;
        URI opEndpointUri = (URI)mapComponentSettings.get("OPEndpoint");
        this._opEndpoint = opEndpointUri != null ? opEndpointUri.toString() : null;
        this._expireIn = (Integer)mapComponentSettings.get("AssocExpiry");
        this.bConfigured = status;
    }

    public void invoke(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request, ISTSResponse response) {
        MessageDigest md;
        AuthSuccess openidResp;
        Association assoc;
        URI uriSubjectNameIdentifierFormat;
        this.log.trace((Object)("TokenGeneratorHandler::invoke: " + strComponentName));
        if (!this.bConfigured) {
            this.setWstFault(constants, response, "The specified request failed", "Issue handler not configured");
            return;
        }
        URI uriDefaultKeyType = (URI)mapComponentSettings.get("DefaultKeyType");
        this.log.trace((Object)("DefaultKeyType: " + uriDefaultKeyType != null ? uriDefaultKeyType.toString() : null));
        Boolean bIncludeBearerSubjectName = (Boolean)mapComponentSettings.get("IncludeBearerSubjectName");
        this.log.trace((Object)("IncludeBearerSubjectName: " + bIncludeBearerSubjectName != null ? bIncludeBearerSubjectName.toString() : null));
        URI uriTokenIssuer = (URI)mapComponentSettings.get("TokenIssuer");
        this.log.trace((Object)("TokenIssuer: " + uriTokenIssuer != null ? uriTokenIssuer.toString() : null));
        if (null == uriTokenIssuer) {
            this.setWstFault(constants, response, "The specified request failed", "TokenIssuer not set.");
            return;
        }
        URI uriSubjectNameIdentifier = (URI)mapComponentSettings.get("SubjectNameIdentifierAttribute");
        if (null != uriSubjectNameIdentifier) {
            this.log.trace((Object)("SubjectNameIdentifier: " + uriSubjectNameIdentifier != null ? uriSubjectNameIdentifier.toString() : null));
        }
        if (null != (uriSubjectNameIdentifierFormat = (URI)mapComponentSettings.get("SubjectNameIdentifierFormat"))) {
            this.log.trace((Object)("SubjectNameIdentifierFormat: " + uriSubjectNameIdentifierFormat != null ? uriSubjectNameIdentifierFormat.toString() : null));
        }
        Boolean bEncryptToken = (Boolean)mapComponentSettings.get("EncryptToken");
        this.log.trace((Object)("EncryptToken: " + bEncryptToken != null ? bEncryptToken.toString() : null));
        List listRST = request.getRequestSecurityTokenCollection();
        IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
        ILifetime ltLifetime = RST.getLifetime();
        URI uriTokenType = RST.getTokenType();
        if (uriTokenType == null || !OpenIDTokenType.OPENID20_TOKEN.toString().equals(uriTokenType.toString()) && !OpenIDTokenType.OPENID11_TOKEN.toString().equals(uriTokenType.toString())) {
            this.setWstFault(constants, response, "Invalid token type", "Cannot handle tokens of type: " + uriTokenType);
            return;
        }
        boolean compat = OpenIDTokenType.OPENID11_TOKEN.equals(uriTokenType.toString());
        IAppliesTo appliesToRequest = RST.getAppliesTo();
        URI uriAppliesTo = null;
        this.log.trace((Object)"Checking for AppliesTo");
        if (appliesToRequest != null) {
            this.log.trace((Object)"Found AppliesTo");
            IEndpointReference eprAppliesTo = appliesToRequest.getEndpointReference();
            uriAppliesTo = eprAppliesTo.getAddress();
        }
        if (uriAppliesTo == null) {
            this.setWstFault(constants, response, "The specified request failed", "AppliesTo / return_url not found; required for OpenID Tokens.");
            return;
        }
        IDigitalIdentity digitalIdentity = RST.getDigitalIdentity();
        if (null == digitalIdentity) {
            this.setWstFault(constants, response, "The specified request failed", "Digital Subject was not found");
            return;
        }
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMNamespace omIdentityNamespace = omFactory.createOMNamespace(constants.getIdentityNamespace().toString(), "ic");
        OMNamespace omWSTrustNamespace = omFactory.createOMNamespace(constants.getWSTrustNamespace().toString(), "wst");
        OMElement omRequestedDisplayToken = omFactory.createOMElement("RequestedDisplayToken", omIdentityNamespace);
        OMElement omDisplayToken = omFactory.createOMElement("DisplayToken", omIdentityNamespace, (OMContainer)omRequestedDisplayToken);
        OMElement omRequestedSecurityToken = omFactory.createOMElement("RequestedSecurityToken", omWSTrustNamespace);
        OMElement omRequestedAttachedReference = omFactory.createOMElement("RequestedAttachedReference", omWSTrustNamespace);
        OMElement omRequestedUnattachedReference = omFactory.createOMElement("RequestedUnattachedReference", omWSTrustNamespace);
        OMNamespace omWSSNamespace = omFactory.createOMNamespace(constants.getWSSecurityNamespace().toString(), "wsse");
        OMElement omSecurityTokenReference1 = omFactory.createOMElement("SecurityTokenReference", omWSSNamespace, (OMContainer)omRequestedAttachedReference);
        OMElement omSecurityTokenReference2 = omFactory.createOMElement("SecurityTokenReference", omWSSNamespace, (OMContainer)omRequestedUnattachedReference);
        OMElement omKeyIdentifier1 = omFactory.createOMElement("KeyIdentifier", omWSSNamespace, (OMContainer)omSecurityTokenReference1);
        OMElement omKeyIdentifier2 = omFactory.createOMElement("KeyIdentifier", omWSSNamespace, (OMContainer)omSecurityTokenReference2);
        String keyIdentifierValueType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1";
        omKeyIdentifier1.addAttribute("ValueType", keyIdentifierValueType, null);
        omKeyIdentifier2.addAttribute("ValueType", keyIdentifierValueType, null);
        String claimedID = null;
        HashMap<String, String> attrs = new HashMap<String, String>();
        List listClaims = digitalIdentity.getClaims();
        Map mapAttributeClaim = (Map)mapGlobalSettings.get("AttributeClaimMap");
        Iterator claimsIter = listClaims.iterator();
        while (claimsIter.hasNext()) {
            String value;
            IClaim claim = (IClaim)claimsIter.next();
            String string = value = claim.getValues().hasNext() ? (String)claim.getValues().next() : null;
            if (value == null) continue;
            String claimTypeUri = claim.getType().getName().toString();
            String displayTag = (String)((Map)mapAttributeClaim.get(claimTypeUri)).get("DisplayName");
            if ("http://schema.openid.net/2007/05/claims/identifier".equals(claimTypeUri)) {
                claimedID = value;
                this.addDisplayClaim(claimTypeUri, claimedID, displayTag, omDisplayToken, omIdentityNamespace, omFactory);
                if (!compat) continue;
                break;
            }
            if (compat) continue;
            attrs.put(claimTypeUri, value);
            this.addDisplayClaim(claimTypeUri, value, displayTag, omDisplayToken, omIdentityNamespace, omFactory);
        }
        if (claimedID == null) {
            this.setWstFault(constants, response, "Cannot process OpenID-token RST", "No claimed identifier found.");
            return;
        }
        try {
            assoc = this._privateAssociations.generate("HMAC-SHA1", this._expireIn);
        }
        catch (AssociationException e) {
            this.setWstFault(constants, response, "Cannot instantiate private association store", e.getMessage());
            return;
        }
        if (!compat && this._opEndpoint == null) {
            this.setWstFault(constants, response, "Cannot process OpenID-token RST", "OP-Endpoint not configured; required for OpenID 2 messages.");
            return;
        }
        String nonce = this._nonceGenerator.next();
        try {
            openidResp = AuthSuccess.createAuthSuccess(this._opEndpoint, claimedID, claimedID, compat, uriAppliesTo.toString(), nonce, null, assoc, false);
            if (!compat) {
                FetchResponse fetchResp = FetchResponse.createFetchResponse();
                fetchResp.addAttributes(attrs);
                openidResp.addExtension(fetchResp);
            }
            openidResp.setSignature(assoc.sign(openidResp.getSignedText()));
        }
        catch (OpenIDException e) {
            this.setWstFault(constants, response, "Cannot generate OpenID assertion", e.getMessage());
            return;
        }
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            this.setWstFault(constants, response, "Cannot create SHA-1 hash for Requested(Un)AttachedReference", e.getMessage());
            return;
        }
        String sha1base64 = null;
        try {
            sha1base64 = Base64.encode((byte[])md.digest(openidResp.keyValueFormEncoding().getBytes("utf-8")));
        }
        catch (UnsupportedEncodingException e) {
            this.setWstFault(constants, response, "Unsupported encoding for the OpenID message", e.getMessage());
            return;
        }
        omKeyIdentifier1.setText(sha1base64);
        omKeyIdentifier2.setText(sha1base64);
        OMNamespace omOpenIDNamespace = omFactory.createOMNamespace("http://specs.openid.net/auth/2.0", "openid");
        OMElement omOpenIDToken = omFactory.createOMElement("OpenIDToken", omOpenIDNamespace, (OMContainer)omRequestedSecurityToken);
        omOpenIDToken.setText(openidResp.keyValueFormEncoding());
        List listRSTR = response.getRequestSecurityTokenResponseCollection();
        if (0 == listRSTR.size()) {
            listRSTR.add(new RequestSecurityTokenResponse());
        }
        RequestSecurityTokenResponse RSTR = (RequestSecurityTokenResponse)listRSTR.get(0);
        try {
            RSTR.setTokenType(uriTokenType);
            RSTR.setLifetime(ltLifetime);
            RSTR.setRequestedSecurityToken(XMLHelper.toElement((OMElement)omRequestedSecurityToken));
            RSTR.setRequestedDisplayToken(XMLHelper.toElement((OMElement)omRequestedDisplayToken));
            RSTR.setRequestedAttachedReference(XMLHelper.toElement((OMElement)omRequestedAttachedReference));
            RSTR.setRequestedUnattachedReference(XMLHelper.toElement((OMElement)omRequestedUnattachedReference));
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            this.setWstFault(constants, response, "The specified request failed", "Failed to set RequestSecurityToken elements.");
        }
    }

    private void setWstFault(IConstants constants, ISTSResponse response, String reason, String detail) {
        Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), reason, detail);
        response.setFault((IFault)fault);
    }

    public void addDisplayClaim(String uri, String value, String displayTag, OMElement omParent, OMNamespace omNs, OMFactory omFactory) {
        OMElement elemDisplayClaim = omFactory.createOMElement("DisplayClaim", omNs, (OMContainer)omParent);
        elemDisplayClaim.addAttribute("Uri", uri, null);
        OMElement elemDisplayTag = omFactory.createOMElement("DisplayTag", omNs, (OMContainer)elemDisplayClaim);
        if (displayTag == null || displayTag.length() == 0) {
            int lastIndex = uri.lastIndexOf("/");
            displayTag = "";
            if (lastIndex > -1 && uri.length() > lastIndex) {
                displayTag = uri.substring(lastIndex + 1);
            }
        }
        elemDisplayTag.setText(displayTag);
        OMElement elemDisplayValue = omFactory.createOMElement("DisplayValue", omNs, (OMContainer)elemDisplayClaim);
        elemDisplayValue.setText(value);
    }
}

