/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.server.RealmVerifier;

public class AuthRequest
extends Message {
    private static Log _log = LogFactory.getLog((Class)AuthRequest.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final String MODE_SETUP = "checkid_setup";
    public static final String MODE_IMMEDIATE = "checkid_immediate";
    public static final String SELECT_ID = "http://specs.openid.net/auth/2.0/identifier_select";
    protected static final List requiredFields = Arrays.asList("openid.mode");
    protected static final List optionalFields = Arrays.asList("openid.ns", "openid.claimed_id", "openid.identity", "openid.assoc_handle", "openid.realm", "openid.trust_root", "openid.return_to");
    private RealmVerifier _realmVerifier;

    protected AuthRequest(String claimedId, String delegate, boolean compatibility, String returnToUrl, String handle, RealmVerifier verifier) {
        this(claimedId, delegate, compatibility, returnToUrl, handle, returnToUrl, verifier);
    }

    protected AuthRequest(String claimedId, String delegate, boolean compatibility, String returnToUrl, String handle, String realm, RealmVerifier verifier) {
        if (!compatibility) {
            this.set("openid.ns", "http://specs.openid.net/auth/2.0");
            this.setClaimed(claimedId);
        }
        this.setIdentity(delegate);
        if (returnToUrl != null) {
            this.setReturnTo(returnToUrl);
        }
        if (realm != null) {
            this.setRealm(realm);
        }
        if (!" ".equals(handle)) {
            this.setHandle(handle);
        }
        this.setImmediate(false);
        this._realmVerifier = verifier;
    }

    protected AuthRequest(ParameterList params) {
        super(params);
    }

    public static AuthRequest createAuthRequest(String claimedId, String delegate, boolean compatibility, String returnToUrl, String handle, RealmVerifier verifier) throws MessageException {
        return AuthRequest.createAuthRequest(claimedId, delegate, compatibility, returnToUrl, handle, returnToUrl, verifier);
    }

    public static AuthRequest createAuthRequest(String claimedId, String delegate, boolean compatibility, String returnToUrl, String handle, String realm, RealmVerifier verifier) throws MessageException {
        AuthRequest req = new AuthRequest(claimedId, delegate, compatibility, returnToUrl, handle, realm, verifier);
        req.validate();
        if (DEBUG) {
            _log.debug((Object)("Created auth request:\n" + req.keyValueFormEncoding()));
        }
        return req;
    }

    public static AuthRequest createAuthRequest(ParameterList params, RealmVerifier realmVerifier) throws MessageException {
        AuthRequest req = new AuthRequest(params);
        req.setRealmVerifier(realmVerifier);
        req.validate();
        if (DEBUG) {
            _log.debug((Object)("Created auth request:\n" + req.keyValueFormEncoding()));
        }
        return req;
    }

    public List getRequiredFields() {
        return requiredFields;
    }

    public void setOPEndpoint(URL opEndpoint) {
        if (opEndpoint != null) {
            this._destinationUrl = opEndpoint.toString();
        }
    }

    public String getOPEndpoint() {
        return this._destinationUrl;
    }

    public void setImmediate(boolean immediate) {
        this.set("openid.mode", immediate ? MODE_IMMEDIATE : MODE_SETUP);
        if (DEBUG && immediate) {
            _log.debug((Object)"Setting checkid_immediate auth request.");
        }
    }

    public boolean isImmediate() {
        return MODE_IMMEDIATE.equals(this.getParameterValue("openid.mode"));
    }

    public boolean isVersion2() {
        return this.hasParameter("openid.ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("openid.ns"));
    }

    public void setIdentity(String id) {
        this.set("openid.identity", id);
    }

    public String getIdentity() {
        return this.getParameterValue("openid.identity");
    }

    public void setClaimed(String claimed) {
        this.set("openid.claimed_id", claimed);
    }

    public String getClaimed() {
        return this.getParameterValue("openid.claimed_id");
    }

    public void setHandle(String handle) {
        this.set("openid.assoc_handle", handle);
    }

    public String getHandle() {
        return this.getParameterValue("openid.assoc_handle");
    }

    public void setReturnTo(String returnTo) {
        this.set("openid.return_to", returnTo);
    }

    public String getReturnTo() {
        return this.getParameterValue("openid.return_to");
    }

    public void setRealm(String realm) {
        this.set(this.isVersion2() ? "openid.realm" : "openid.trust_root", realm);
    }

    public String getRealm() {
        if (this.isVersion2()) {
            return this.getParameterValue("openid.realm");
        }
        return this.getParameterValue("openid.trust_root");
    }

    public RealmVerifier getRealmVerifier() {
        return this._realmVerifier;
    }

    public void setRealmVerifier(RealmVerifier realmVerifier) {
        this._realmVerifier = realmVerifier;
    }

    public void validate() throws MessageException {
        boolean compatibility;
        super.validate();
        boolean bl = compatibility = !this.isVersion2();
        if (compatibility && this.hasParameter("openid.ns")) {
            throw new MessageException("Invalid value for openid.ns field: " + this.getParameterValue("openid.ns"), 768);
        }
        if (compatibility && this.hasParameter("openid.identity") && SELECT_ID.equals(this.getParameterValue("openid.identity"))) {
            throw new MessageException("http://specs.openid.net/auth/2.0/identifier_select not supported in OpenID1", 768);
        }
        if (this.hasParameter("openid.mode") && !MODE_SETUP.equals(this.getParameterValue("openid.mode")) && !MODE_IMMEDIATE.equals(this.getParameterValue("openid.mode"))) {
            throw new MessageException("Invalid openid.mode value in auth request: " + this.getParameterValue("openid.mode"), 768);
        }
        try {
            if (this.getReturnTo() != null) {
                new URL(this.getReturnTo());
            }
        }
        catch (MalformedURLException e) {
            throw new MessageException("Error verifying return URL in auth request.", 768, e);
        }
        if (!this.hasParameter("openid.return_to")) {
            if (compatibility) {
                throw new MessageException("openid.return_to is mandatory in OpenID1 auth requests", 768);
            }
            if (!this.hasParameter("openid.realm")) {
                throw new MessageException("openid.realm is mandatory if return_to is absent.", 769);
            }
        }
        if (compatibility && this.hasParameter("openid.realm")) {
            _log.warn((Object)"openid.realm should not be present in OpenID1 auth requests");
        }
        if (!compatibility && this.hasParameter("openid.trust_root")) {
            _log.warn((Object)"openid.trust_root should not be present in OpenID2 auth requests.");
        }
        if (!this.hasParameter("openid.identity")) {
            if (compatibility) {
                throw new MessageException("openid.identity is required in OpenID1 auth requests", 768);
            }
            boolean hasAuthProvider = false;
            Iterator iter = this.getExtensions().iterator();
            while (iter.hasNext()) {
                String typeUri = iter.next().toString();
                try {
                    MessageExtension extension = this.getExtension(typeUri);
                    if (!extension.providesIdentifier()) continue;
                    hasAuthProvider = true;
                    break;
                }
                catch (MessageException ignore) {
                }
            }
            if (!hasAuthProvider) {
                throw new MessageException("no identifier specified in auth request", 768);
            }
            if (this.hasParameter("openid.claimed_id")) {
                throw new MessageException("openid.claimed_id must be present if and only if openid.identity is present.", 768);
            }
        } else if (!compatibility && !this.hasParameter("openid.claimed_id")) {
            throw new MessageException("openid.clamied_id must be present in OpenID2 auth requests", 768);
        }
        if (this.getRealm() != null && 0 != this._realmVerifier.validate(this.getRealm(), this.getReturnTo())) {
            throw new MessageException("Realm verification failed for: " + this.getRealm(), 769);
        }
    }
}

