/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;

public class ParameterList
implements Serializable {
    private static Log _log = LogFactory.getLog((Class)ParameterList.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    Map _parameterMap;

    public ParameterList() {
        this._parameterMap = new LinkedHashMap();
        if (DEBUG) {
            _log.debug((Object)"Created empty parameter list.");
        }
    }

    public ParameterList(ParameterList that) {
        if (DEBUG) {
            _log.debug((Object)("Cloning parameter list:\n" + that));
        }
        this._parameterMap = new LinkedHashMap(that._parameterMap);
    }

    public ParameterList(Map parameterMap) {
        this._parameterMap = new LinkedHashMap();
        Iterator keysIter = parameterMap.keySet().iterator();
        while (keysIter.hasNext()) {
            String value;
            String name = (String)keysIter.next();
            Object v = parameterMap.get(name);
            if (v instanceof Object[]) {
                Object[] values = (Object[])v;
                if (values.length > 1 && name.startsWith("openid.")) {
                    throw new IllegalArgumentException("Multiple parameters with the same name: " + values);
                }
                value = values.length > 0 ? (String)values[0] : null;
            } else {
                value = (String)v;
            }
            this.set(new Parameter(name, value));
        }
        if (DEBUG) {
            _log.debug((Object)("Creating parameter list:\n" + this));
        }
    }

    public void copyOf(ParameterList that) {
        if (DEBUG) {
            _log.debug((Object)("Copying parameter list:\n" + that));
        }
        this._parameterMap = new LinkedHashMap(that._parameterMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterList that = (ParameterList)obj;
        return ((Object)this._parameterMap).equals(that._parameterMap);
    }

    public int hashCode() {
        return ((Object)this._parameterMap).hashCode();
    }

    public void set(Parameter parameter) {
        this._parameterMap.put(parameter.getKey(), parameter);
    }

    public void addParams(ParameterList params) {
        Iterator iter = params.getParameters().iterator();
        while (iter.hasNext()) {
            this.set((Parameter)iter.next());
        }
    }

    public Parameter getParameter(String name) {
        return (Parameter)this._parameterMap.get(name);
    }

    public String getParameterValue(String name) {
        Parameter param = this.getParameter(name);
        return param != null ? param.getValue() : null;
    }

    public List getParameters() {
        return new ArrayList(this._parameterMap.values());
    }

    public void removeParameters(String name) {
        this._parameterMap.remove(name);
    }

    public boolean hasParameter(String name) {
        return this._parameterMap.containsKey(name);
    }

    public static ParameterList createFromQueryString(String queryString) throws MessageException {
        if (DEBUG) {
            _log.debug((Object)("Creating parameter list from query string: " + queryString));
        }
        ParameterList parameterList = new ParameterList();
        StringTokenizer tokenizer = new StringTokenizer(queryString, "&");
        while (tokenizer.hasMoreTokens()) {
            String keyValue = tokenizer.nextToken();
            int posEqual = keyValue.indexOf(61);
            if (posEqual == -1) {
                throw new MessageException("Invalid query parameter, = missing: " + keyValue);
            }
            try {
                String key = URLDecoder.decode(keyValue.substring(0, posEqual), "UTF-8");
                String value = URLDecoder.decode(keyValue.substring(posEqual + 1), "UTF-8");
                parameterList.set(new Parameter(key, value));
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageException("Cannot URL decode query parameter: " + keyValue, (Throwable)e);
            }
        }
        return parameterList;
    }

    public static ParameterList createFromKeyValueForm(String keyValueForm) throws MessageException {
        if (DEBUG) {
            _log.debug((Object)("Creating parameter list from key-value form:\n" + keyValueForm));
        }
        ParameterList parameterList = new ParameterList();
        StringTokenizer tokenizer = new StringTokenizer(keyValueForm, "\n");
        while (tokenizer.hasMoreTokens()) {
            String keyValue = tokenizer.nextToken();
            int posColon = keyValue.indexOf(58);
            if (posColon == -1) {
                throw new MessageException("Invalid Key-Value form, colon missing: " + keyValue);
            }
            String key = keyValue.substring(0, posColon);
            String value = keyValue.substring(posColon + 1);
            parameterList.set(new Parameter(key, value));
        }
        return parameterList;
    }

    public String toString() {
        StringBuffer allParams = new StringBuffer("");
        List parameters = this.getParameters();
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            allParams.append(parameter.getKey());
            allParams.append(':');
            allParams.append(parameter.getValue());
            allParams.append('\n');
        }
        return allParams.toString();
    }
}

