/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.ax;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxMessage;
import org.openid4java.message.ax.FetchRequest;

public class FetchResponse
extends AxMessage {
    private static Log _log = LogFactory.getLog((Class)FetchResponse.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private int _attrAliasGen = 0;

    protected FetchResponse() {
        this._parameters.set(new Parameter("mode", "fetch_response"));
        if (DEBUG) {
            _log.debug((Object)"Created empty fetch response.");
        }
    }

    public static FetchResponse createFetchResponse() {
        return new FetchResponse();
    }

    protected FetchResponse(ParameterList params) {
        this._parameters = params;
    }

    public static FetchResponse createFetchResponse(ParameterList params) throws MessageException {
        FetchResponse resp = new FetchResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid parameters for a fetch response");
        }
        if (DEBUG) {
            _log.debug((Object)("Created fetch response from parameter list:\n" + params));
        }
        return resp;
    }

    public static FetchResponse createFetchResponse(FetchRequest req, Map userData) throws MessageException {
        FetchResponse resp = new FetchResponse();
        Map attributes = req.getAttributes();
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String alias = (String)i.next();
            Object value = userData.get(alias);
            if (value == null) continue;
            if (value instanceof String) {
                resp.addAttribute(alias, (String)attributes.get(alias), (String)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            Iterator values = ((List)value).iterator();
            int max = req.getCount(alias);
            for (int count = 0; count < max && values.hasNext(); ++count) {
                String val = (String)values.next();
                if (val == null) {
                    --count;
                    continue;
                }
                resp.addAttribute(alias, (String)attributes.get(alias), val);
            }
        }
        return resp;
    }

    public void addAttribute(String alias, String typeUri, String value) throws MessageException {
        if (alias.indexOf(44) > -1 || alias.indexOf(46) > -1 || alias.indexOf(58) > -1 || alias.indexOf(10) > -1) {
            throw new MessageException("Characters [.,:\\n] are not allowed in attribute aliases: " + alias);
        }
        int count = this.getCount(alias);
        String index = "";
        switch (count) {
            case 0: {
                this._parameters.set(new Parameter("type." + alias, typeUri));
                break;
            }
            case 1: {
                this._parameters.set(new Parameter("value." + alias + ".1", this.getParameterValue("value." + alias)));
                this._parameters.removeParameters("value." + alias);
                index = ".2";
                break;
            }
            default: {
                index = "." + Integer.toString(count + 1);
            }
        }
        this._parameters.set(new Parameter("value." + alias + index, value));
        this.setCount(alias, ++count);
        if (DEBUG) {
            _log.debug((Object)("Added new attribute to fetch response; type: " + typeUri + " alias: " + alias + " count: " + count));
        }
    }

    public String addAttribute(String typeUri, String value) {
        ++this._attrAliasGen;
        String alias = "attr" + this._attrAliasGen;
        this._parameters.set(new Parameter("type." + alias, typeUri));
        this._parameters.set(new Parameter("value." + alias, value));
        if (DEBUG) {
            _log.debug((Object)("Added new attribute to fetch response; type: " + typeUri + " alias: " + alias));
        }
        return alias;
    }

    public void addAttributes(Map attributes) {
        Iterator iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String typeUri = (String)iter.next();
            this.addAttribute(typeUri, (String)attributes.get(typeUri));
        }
    }

    public List getAttributeValues(String alias) {
        ArrayList<String> values = new ArrayList<String>();
        if (!this._parameters.hasParameter("count." + alias)) {
            values.add(this.getParameterValue("value." + alias));
        } else {
            for (int i = 1; i <= this.getCount(alias); ++i) {
                values.add(this.getParameterValue("value." + alias + "." + Integer.toString(i)));
            }
        }
        return values;
    }

    public String getAttributeValue(String alias) {
        return this.getCount(alias) > 1 ? this.getParameterValue("value." + alias + ".1") : this.getParameterValue("value." + alias);
    }

    public List getAttributeAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String alias;
            String paramName = ((Parameter)it.next()).getKey();
            if (!paramName.startsWith("type.") || aliases.contains(alias = paramName.substring(5))) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    public Map getAttributes() {
        HashMap<String, List> attributes = new HashMap<String, List>();
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String alias;
            String paramName = ((Parameter)it.next()).getKey();
            if (!paramName.startsWith("type.") || attributes.containsKey(alias = paramName.substring(5))) continue;
            attributes.put(alias, this.getAttributeValues(alias));
        }
        return attributes;
    }

    public Map getAttributeTypes() {
        HashMap<String, String> typeUris = new HashMap<String, String>();
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String alias;
            Parameter param = (Parameter)it.next();
            String paramName = param.getKey();
            String paramType = param.getValue();
            if (!paramName.startsWith("type.") || typeUris.containsKey(alias = paramName.substring(5))) continue;
            typeUris.put(alias, paramType);
        }
        return typeUris;
    }

    public int getCount(String alias) {
        if (this._parameters.hasParameter("count." + alias)) {
            return Integer.parseInt(this._parameters.getParameterValue("count." + alias));
        }
        if (this._parameters.hasParameter("value." + alias)) {
            return 1;
        }
        return 0;
    }

    private void setCount(String alias, int count) {
        if (count > 1) {
            this._parameters.set(new Parameter("count." + alias, Integer.toString(count)));
        }
    }

    public void setUpdateUrl(String updateUrl) throws MessageException {
        try {
            new URL(updateUrl);
        }
        catch (MalformedURLException e) {
            throw new MessageException("Invalid update_url: " + updateUrl);
        }
        if (DEBUG) {
            _log.debug((Object)("Setting fetch response update_url: " + updateUrl));
        }
        this._parameters.set(new Parameter("update_url", updateUrl));
    }

    public String getUpdateUrl() {
        return this._parameters.hasParameter("update_url") ? this._parameters.getParameterValue("update_url") : null;
    }

    private boolean isValid() {
        if (!this._parameters.hasParameter("mode") || !"fetch_response".equals(this._parameters.getParameterValue("mode"))) {
            _log.warn((Object)("Invalid mode value in fetch_reponse: " + this._parameters.getParameterValue("mode")));
            return false;
        }
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (paramName.equals("mode") || paramName.startsWith("type.") || paramName.startsWith("count.") || paramName.startsWith("value.") || paramName.equals("update_url")) continue;
            _log.warn((Object)("Invalid parameter name in fetch response: " + paramName));
        }
        return this.checkAttributes();
    }

    private boolean checkAttributes() {
        List aliases = this.getAttributeAliases();
        Iterator it = aliases.iterator();
        while (it.hasNext()) {
            String alias = (String)it.next();
            if (!this._parameters.hasParameter("type." + alias)) {
                _log.warn((Object)("Type missing for attribute alias: " + alias));
                return false;
            }
            if (!this._parameters.hasParameter("count." + alias)) {
                if (this._parameters.hasParameter("value." + alias)) continue;
                _log.warn((Object)("Value missing for attribute alias: " + alias));
                return false;
            }
            if (this._parameters.hasParameter("value." + alias)) {
                _log.warn((Object)("Count parameter present for alias: " + alias + "; should use " + alias + ".[index] format"));
                return false;
            }
            int count = this.getCount(alias);
            if (count < 0) {
                _log.warn((Object)("Invalid value for count." + alias + ": " + count));
                return false;
            }
            for (int i = 1; i <= count; ++i) {
                if (this._parameters.hasParameter("value." + alias + "." + Integer.toString(i))) continue;
                _log.warn((Object)("Value missing for alias: " + alias + "." + Integer.toString(i)));
                return false;
            }
        }
        return true;
    }
}

