/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.sreg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.sreg.SRegMessage;
import org.openid4java.message.sreg.SRegRequest;

public class SRegResponse
extends SRegMessage {
    private static Log _log = LogFactory.getLog((Class)SRegResponse.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List SREG_FIELDS = Arrays.asList("nickname", "email", "fullname", "dob", "gender", "postcode", "country", "language", "timezone");

    protected SRegResponse() {
        if (DEBUG) {
            _log.debug((Object)"Created empty fetch response.");
        }
    }

    public static SRegResponse createFetchResponse() {
        return new SRegResponse();
    }

    protected SRegResponse(ParameterList params) {
        this._parameters = params;
    }

    public static SRegResponse createSRegResponse(ParameterList params) throws MessageException {
        SRegResponse resp = new SRegResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid parameters for a SReg response");
        }
        if (DEBUG) {
            _log.debug((Object)("Created SReg response from parameter list:\n" + params));
        }
        return resp;
    }

    public static SRegResponse createSRegResponse(SRegRequest req, Map userData) throws MessageException {
        SRegResponse resp = new SRegResponse();
        List attributes = req.getAttributes();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            String attr = (String)iter.next();
            String value = (String)userData.get(attr);
            if (value == null) continue;
            resp.addAttribute(attr, value);
        }
        return resp;
    }

    public void addAttribute(String attr, String value) throws MessageException {
        this._parameters.set(new Parameter(attr, value));
        if (!SREG_FIELDS.contains(attr)) {
            throw new MessageException("Invalid attribute for SReg: " + attr);
        }
        if (DEBUG) {
            _log.debug((Object)("Added new attribute to SReg response: " + attr + " value: " + value));
        }
    }

    public String getAttributeValue(String attr) {
        return this.getParameterValue(attr);
    }

    public List getAttributeNames() {
        ArrayList<String> attributes = new ArrayList<String>();
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            attributes.add(((Parameter)it.next()).getKey());
        }
        return attributes;
    }

    public Map getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String attr = ((Parameter)it.next()).getKey();
            attributes.put(attr, this.getAttributeValue(attr));
        }
        return attributes;
    }

    private boolean isValid() {
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (SREG_FIELDS.contains(paramName)) continue;
            _log.warn((Object)("Invalid parameter name in SReg response: " + paramName));
            return false;
        }
        return true;
    }
}

