/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.server;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openid4java.message.DirectError;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;
import org.openid4java.server.ServerException;
import org.openid4java.server.ServerManager;

public class SampleServer {
    public ServerManager manager = new ServerManager();

    public SampleServer() {
        this.manager.setOPEndpointUrl("Http://my.openidprovider.com/server");
    }

    public String processRequest(HttpServletRequest httpReq, HttpServletResponse httpResp) throws Exception {
        String responseText;
        String mode;
        ParameterList request = new ParameterList(httpReq.getParameterMap());
        String string = mode = request.hasParameter("openid.mode") ? request.getParameterValue("openid.mode") : null;
        if ("associate".equals(mode)) {
            Message response = this.manager.associationResponse(request);
            responseText = response.keyValueFormEncoding();
        } else {
            if ("checkid_setup".equals(mode) || "checkid_immediate".equals(mode)) {
                Boolean authenticatedAndApproved;
                String userSelectedClaimedId;
                List userData = this.userInteraction(request);
                String userSelectedId = (String)userData.get(0);
                Message response = this.manager.authResponse(request, userSelectedId, userSelectedClaimedId = (String)userData.get(1), authenticatedAndApproved = (Boolean)userData.get(2));
                if (response instanceof DirectError) {
                    return this.directResponse(httpResp, response.keyValueFormEncoding());
                }
                return response.getDestinationUrl(true);
            }
            if ("check_authentication".equals(mode)) {
                Message response = this.manager.verify(request);
                responseText = response.keyValueFormEncoding();
            } else {
                DirectError response = DirectError.createDirectError("Unknown request");
                responseText = response.keyValueFormEncoding();
            }
        }
        return responseText;
    }

    private List userInteraction(ParameterList request) throws ServerException {
        throw new ServerException("User-interaction not implemented.");
    }

    private String directResponse(HttpServletResponse httpResp, String response) throws IOException {
        ServletOutputStream os = httpResp.getOutputStream();
        os.write(response.getBytes());
        os.close();
        return null;
    }
}

