/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.analysis;

import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.timecode.AudioTimecode;

public class BeatDetector
extends AudioProcessor {
    private float kBeatFilter;
    private float filter1Out = 0.0f;
    private float filter2Out = 0.0f;
    private float beatRelease;
    private float peakEnv = 0.0f;
    private boolean beatTrigger = false;
    private boolean prevBeatPulse = false;
    private boolean beatPulse;
    private final AudioTimecode beatTimecode = new AudioTimecode(0L);
    private boolean beatDetected = false;
    public static final float FREQ_LP_BEAT = 150.0f;
    public static final float T_FILTER = 0.001061033f;
    public static final float BEAT_RTIME = 0.02f;

    public BeatDetector(AudioFormat af) {
        this(null, af);
    }

    public BeatDetector(AudioStream as) {
        this(as, as.getFormat());
    }

    protected BeatDetector(AudioStream as, AudioFormat af) {
        super(as);
        this.format = af;
        this.setSampleRate((float)(af.getSampleRateKHz() * 1000.0));
    }

    private void setSampleRate(float sampleRate) {
        this.kBeatFilter = (float)(1.0 / (double)(sampleRate * 0.001061033f));
        this.beatRelease = (float)Math.exp(-1.0f / (sampleRate * 0.02f));
    }

    public SampleChunk process(SampleChunk samples) {
        int i;
        this.beatDetected = false;
        SampleBuffer sb = samples.getSampleBuffer();
        for (i = 0; i < sb.size() && !(this.beatDetected = this.processSample(sb.get(i))); ++i) {
        }
        if (this.beatDetected()) {
            this.beatTimecode.setTimecodeInMilliseconds((long)((double)samples.getStartTimecode().getTimecodeInMilliseconds() + (double)i * this.format.getSampleRateKHz()));
        }
        return samples;
    }

    private boolean processSample(float in) {
        float input = in / 2.1474836E9f;
        this.filter1Out += this.kBeatFilter * (input - this.filter1Out);
        this.filter2Out += this.kBeatFilter * (this.filter1Out - this.filter2Out);
        float EnvIn = Math.abs(this.filter2Out);
        if (EnvIn > this.peakEnv) {
            this.peakEnv = EnvIn;
        } else {
            this.peakEnv *= this.beatRelease;
            this.peakEnv += (1.0f - this.beatRelease) * EnvIn;
        }
        if (!this.beatTrigger) {
            if ((double)this.peakEnv > 0.3) {
                this.beatTrigger = true;
            }
        } else if ((double)this.peakEnv < 0.15) {
            this.beatTrigger = false;
        }
        this.beatPulse = false;
        if (this.beatTrigger && !this.prevBeatPulse) {
            this.beatPulse = true;
        }
        this.prevBeatPulse = this.beatTrigger;
        return this.beatPulse;
    }

    public boolean beatDetected() {
        return this.beatDetected;
    }

    public AudioTimecode getBeatTimecode() {
        return this.beatTimecode;
    }
}

