/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.analysis;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.samples.SampleBufferFactory;

public class FourierTransform
extends AudioProcessor {
    private float[][] lastFFT = null;
    private float scalingFactor = 1.0f;
    private boolean padToNextPowerOf2 = true;
    private final boolean normalise = true;

    public FourierTransform() {
    }

    public FourierTransform(AudioStream as) {
        super(as);
    }

    public SampleChunk process(SampleChunk sample) {
        SampleBuffer sb = sample.getSampleBuffer();
        return this.process(sb).getSampleChunk();
    }

    public SampleBuffer process(SampleBuffer sb) {
        int nChannels = sb.getFormat().getNumChannels();
        int nSamplesPerChannel = sb.size() / nChannels;
        int sizeOfFFT = this.padToNextPowerOf2 ? this.nextPowerOf2(nSamplesPerChannel) : nSamplesPerChannel;
        FloatFFT_1D fft = new FloatFFT_1D(nSamplesPerChannel);
        this.lastFFT = new float[nChannels][];
        for (int c = 0; c < nChannels; ++c) {
            this.lastFFT[c] = new float[sizeOfFFT * 2];
            for (int x = 0; x < nSamplesPerChannel; ++x) {
                this.lastFFT[c][x * 2] = sb.get(x * nChannels + c) * this.scalingFactor;
            }
            fft.complexForward(this.lastFFT[c]);
            ((Object)((Object)this)).getClass();
            this.normaliseReals(sizeOfFFT);
        }
        return sb;
    }

    private void normaliseReals(int size) {
        for (int c = 0; c < this.lastFFT.length; ++c) {
            for (int i = 0; i < this.lastFFT[c].length; i += 2) {
                float[] fArray = this.lastFFT[c];
                int n = i;
                fArray[n] = fArray[n] / (float)size;
            }
        }
    }

    private int nextPowerOf2(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    public static SampleChunk inverseTransform(AudioFormat format, float[][] transformedData) {
        if (transformedData == null || transformedData.length == 0) {
            throw new IllegalArgumentException("No data in data chunk");
        }
        if (transformedData.length != format.getNumChannels()) {
            throw new IllegalArgumentException("Number of channels in audio format does not match given data.");
        }
        int nChannels = transformedData.length;
        FloatFFT_1D fft = new FloatFFT_1D(transformedData[0].length / 2);
        SampleBuffer sb = SampleBufferFactory.createSampleBuffer((AudioFormat)format, (int)(transformedData[0].length / 2 * nChannels));
        for (int channel = 0; channel < transformedData.length; ++channel) {
            fft.complexInverse(transformedData[channel], true);
            for (int x = 0; x < transformedData[channel].length / 2; ++x) {
                sb.set(x * nChannels + channel, transformedData[channel][x]);
            }
        }
        return sb.getSampleChunk();
    }

    public float[][] getLastFFT() {
        return this.lastFFT;
    }

    public float[][] getMagnitudes() {
        float[][] mags = new float[this.lastFFT.length][];
        for (int c = 0; c < this.lastFFT.length; ++c) {
            mags[c] = new float[this.lastFFT[c].length / 4];
            for (int i = 0; i < this.lastFFT[c].length / 4; ++i) {
                float re = this.lastFFT[c][i * 2];
                float im = this.lastFFT[c][i * 2 + 1];
                mags[c][i] = (float)Math.sqrt(re * re + im * im);
            }
        }
        return mags;
    }

    public float[][] getPowerMagnitudes() {
        float[][] mags = new float[this.lastFFT.length][];
        for (int c = 0; c < this.lastFFT.length; ++c) {
            mags[c] = new float[this.lastFFT[c].length / 4];
            for (int i = 0; i < this.lastFFT[c].length / 4; ++i) {
                float re = this.lastFFT[c][i * 2];
                float im = this.lastFFT[c][i * 2 + 1];
                mags[c][i] = 10.0f * (float)Math.log10(re * re + im * im);
            }
        }
        return mags;
    }

    public float[][] getNormalisedMagnitudes(float scalar) {
        float[][] mags = new float[this.lastFFT.length][];
        for (int c = 0; c < this.lastFFT.length; ++c) {
            mags[c] = new float[this.lastFFT[c].length / 4];
            for (int i = 0; i < this.lastFFT[c].length / 4; ++i) {
                float re = this.lastFFT[c][i * 2] * scalar;
                float im = this.lastFFT[c][i * 2 + 1] * scalar;
                mags[c][i] = re * re + im * im;
            }
        }
        return mags;
    }

    public float[][] getReals() {
        float[][] reals = new float[this.lastFFT.length][];
        for (int c = 0; c < this.lastFFT.length; ++c) {
            reals[c] = new float[this.lastFFT[c].length / 2];
            for (int i = 0; i < this.lastFFT[c].length / 2; ++i) {
                reals[c][i] = this.lastFFT[c][i * 2];
            }
        }
        return reals;
    }

    public float getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(float scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public boolean isPadToNextPowerOf2() {
        return this.padToNextPowerOf2;
    }

    public void setPadToNextPowerOf2(boolean padToNextPowerOf2) {
        this.padToNextPowerOf2 = padToNextPowerOf2;
    }
}

