/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.analysis;

import java.util.Iterator;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;

public class PeakNormalisationCalculator
extends AudioProcessor {
    private float scalar = Float.MAX_VALUE;

    public SampleChunk process(SampleChunk sample) throws Exception {
        SampleBuffer sb = sample.getSampleBuffer();
        Iterator iterator = sb.iterator();
        while (iterator.hasNext()) {
            float s = ((Float)iterator.next()).floatValue();
            if (!(Math.abs(s) * this.scalar > 1.0f)) continue;
            this.scalar = 1.0f / Math.abs(s);
        }
        return sample;
    }

    public float getVolumeScalar() {
        return this.scalar;
    }
}

