/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.analysis;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.analysis.FourierTransform;
import org.openimaj.audio.processor.AudioProcessor;

public class PowerCepstrumTransform
extends AudioProcessor {
    private float[][] lastCepstrum = null;

    public SampleChunk process(SampleChunk sample) throws Exception {
        FourierTransform fft = new FourierTransform();
        fft.process(sample);
        float[][] fftCoeffs = fft.getLastFFT();
        float[][] logMags = new float[fftCoeffs.length][];
        for (int c = 0; c < fftCoeffs.length; ++c) {
            logMags[c] = new float[fftCoeffs[c].length / 4];
            for (int i = 0; i < fftCoeffs[c].length / 4; ++i) {
                float logMag;
                float re = fftCoeffs[c][i * 2];
                float im = fftCoeffs[c][i * 2 + 1];
                float mag = (float)Math.log(Math.sqrt(re * re + im * im) + 1.0);
                mag *= mag;
                logMags[c][i] = logMag = (float)Math.log(mag);
            }
        }
        this.lastCepstrum = new float[logMags.length][];
        FloatFFT_1D fft2 = new FloatFFT_1D(logMags[0].length / 4);
        for (int c = 0; c < logMags.length; ++c) {
            fft2.complexForward(logMags[c]);
            this.lastCepstrum[c] = new float[logMags[c].length / 4];
            for (int i = 0; i < logMags[c].length / 4; ++i) {
                float re = logMags[c][i * 2];
                float im = logMags[c][i * 2 + 1];
                float mag = (float)Math.log(Math.sqrt(re * re + im * im) + 1.0);
                mag *= mag;
                this.lastCepstrum[c][i] = mag;
            }
        }
        return sample;
    }

    public float[][] getLastCepstrum() {
        return this.lastCepstrum;
    }
}

