/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.analysis.benchmarking.dataset;

import cern.colt.Arrays;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.annotations.DatasetDescription;

@DatasetDescription(name="Music-Speech Dataset", description="The 'music-speech' corpus is a small collection of some 240 15-second extracts collected 'at random' from the radio by Eric Scheirer during his internship at Interval Research Corporation in the summer of 1996 under the supervision of Malcolm Slaney", url="http://labrosa.ee.columbia.edu/sounds/musp/scheislan.html")
@Reference(type=ReferenceType.Inproceedings, author={"Scheirer E.", "Slaney, M."}, title="Construction And Evaluation Of A Robust Multifeature Speech/music Discriminator", year="1997", booktitle="Proc. ICASSP-97, Munich.")
public class MusicSpeechDataset
extends MapBackedDataset<String, Dataset<File>, File> {
    private File soundsDir;

    public MusicSpeechDataset(File baseDir, boolean testOrTrain) {
        String soundsDir = "wavfile" + File.separator;
        soundsDir = soundsDir + (testOrTrain ? "test" : "train");
        this.soundsDir = new File(baseDir, soundsDir);
        this.processDir(this.soundsDir);
        System.out.println((Object)this);
    }

    private void processDir(File dir) {
        Object[] groups = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().equals(".") && !pathname.getName().equals("..");
            }
        });
        System.out.println(Arrays.toString((Object[])groups));
        if (groups.length == 0) {
            System.out.println("Processing " + dir);
            File[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".wav");
                }
            });
            ListBackedDataset list = new ListBackedDataset();
            this.map.put(dir.getAbsolutePath().substring(this.soundsDir.getAbsolutePath().length() + 1), list);
            for (File file : files) {
                list.add((Object)file);
            }
        } else {
            for (Object group : groups) {
                this.processDir((File)group);
            }
        }
    }
}

