/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.conversion;

import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.samples.SampleBufferFactory;

public class MultichannelToMonoProcessor
extends AudioProcessor {
    public MultichannelToMonoProcessor() {
    }

    public MultichannelToMonoProcessor(AudioStream a) {
        super(a);
        this.setFormat(this.getFormat().clone().setNumChannels(1));
    }

    public SampleChunk process(SampleChunk sample) {
        if (sample.getFormat().getNumChannels() == 1) {
            return sample;
        }
        SampleBuffer sb = sample.getSampleBuffer();
        int nChannels = sample.getFormat().getNumChannels();
        SampleBuffer sb2 = SampleBufferFactory.createSampleBuffer((AudioFormat)sb.getFormat().clone().setNumChannels(1), (int)(sb.size() / nChannels));
        for (int i = 0; i < sb2.size(); ++i) {
            double acc = 0.0;
            for (int c = 0; c < nChannels; ++c) {
                acc += (double)sb.get(i * nChannels + c);
            }
            sb2.set(i, (float)((int)(acc / (double)nChannels)));
        }
        return sb2.getSampleChunk();
    }
}

