/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.features;

import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.feature.DoubleFV;
import org.openimaj.util.array.ArrayUtils;

public abstract class JAudioFeatureExtractor
extends AudioProcessor
implements org.openimaj.feature.FeatureExtractor<DoubleFV, SampleChunk> {
    protected FeatureExtractor featureExtractor;
    private double[][] lastCalculatedFeature;

    public JAudioFeatureExtractor() {
    }

    public JAudioFeatureExtractor(AudioStream as) {
        super(as);
    }

    public SampleBuffer process(SampleBuffer sb) {
        double[][] chanSamples = sb.asDoubleChannelArray();
        this.lastCalculatedFeature = new double[chanSamples.length][];
        for (int c = 0; c < sb.getFormat().getNumChannels(); ++c) {
            this.lastCalculatedFeature[c] = this.process(chanSamples[c], sb.getFormat().getSampleRateKHz() * 1000.0);
        }
        return sb;
    }

    public double[][] process(double[][] samples, double sampleRate) {
        double[][] featureVectors = new double[samples.length][];
        for (int i = 0; i < samples.length; ++i) {
            featureVectors[i] = this.process(samples[i], sampleRate);
        }
        return featureVectors;
    }

    public double[] process(double[] samples, double sampleRate) {
        try {
            double[] f = this.featureExtractor.extractFeature(samples, sampleRate, this.getExtraInputs(samples, sampleRate));
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract double[][] getExtraInputs(double[] var1, double var2);

    public SampleChunk process(SampleChunk sample) throws Exception {
        this.process(sample.getSampleBuffer());
        return sample;
    }

    public DoubleFV extractFeature(SampleChunk sc) {
        this.process(sc.getSampleBuffer());
        return new DoubleFV(ArrayUtils.reshape((double[][])this.lastCalculatedFeature));
    }

    public double[][] getLastCalculatedFeature() {
        return this.lastCalculatedFeature;
    }

    public void setLastCalculatedFeature(double[][] lastCalculatedFeature) {
        this.lastCalculatedFeature = lastCalculatedFeature;
    }
}

