/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;

public class EQFilter
extends AudioProcessor {
    private EQType type = null;
    private EQVars vars = null;
    private double frequency = 0.0;
    private double xm1 = 0.0;
    private double xm2 = 0.0;
    private double xm3 = 0.0;
    private double xm4 = 0.0;
    private double ym1 = 0.0;
    private double ym2 = 0.0;
    private double ym3 = 0.0;
    private double ym4 = 0.0;

    public EQFilter(EQType type, double f) {
        this.type = type;
        this.frequency = f;
    }

    public EQFilter(AudioStream as, EQType type, double f) {
        super(as);
        this.type = type;
        this.frequency = f;
    }

    public SampleChunk process(SampleChunk sample) throws Exception {
        if (this.vars == null) {
            this.vars = this.type.getCoefficients(this.frequency, sample.getFormat().getSampleRateKHz() * 1000.0);
        }
        SampleBuffer sb = sample.getSampleBuffer();
        int nChans = sample.getFormat().getNumChannels();
        for (int c = 0; c < nChans; ++c) {
            this.xm4 = 0.0;
            this.xm3 = 0.0;
            this.xm2 = 0.0;
            this.xm1 = 0.0;
            this.ym4 = 0.0;
            this.ym3 = 0.0;
            this.ym2 = 0.0;
            this.ym1 = 0.0;
            for (int n = c; n < sb.size(); n += nChans) {
                double tempx = sb.get(n);
                double tempy = this.vars.a0 * tempx + this.vars.a1 * this.xm1 + this.vars.a2 * this.xm2 + this.vars.a3 * this.xm3 + this.vars.a4 * this.xm4 - this.vars.b1 * this.ym1 - this.vars.b2 * this.ym2 - this.vars.b3 * this.ym3 - this.vars.b4 * this.ym4;
                this.xm4 = this.xm3;
                this.xm3 = this.xm2;
                this.xm2 = this.xm1;
                this.xm1 = tempx;
                this.ym4 = this.ym3;
                this.ym3 = this.ym2;
                this.ym2 = this.ym1;
                this.ym1 = tempy;
                sb.set(n, (float)tempy);
            }
        }
        return sample;
    }

    public static enum EQType {
        LPF{

            @Override
            public EQVars getCoefficients(double frequency, double sampleRate) {
                double wc = Math.PI * 2 * frequency;
                double wc2 = wc * wc;
                double wc3 = wc2 * wc;
                double wc4 = wc2 * wc2;
                double k = wc / Math.tan(Math.PI * frequency / sampleRate);
                double k2 = k * k;
                double k3 = k2 * k;
                double k4 = k2 * k2;
                double sqrt2 = Math.sqrt(2.0);
                double sq_tmp1 = sqrt2 * wc3 * k;
                double sq_tmp2 = sqrt2 * wc * k3;
                double a_tmp = 4.0 * wc2 * k2 + 2.0 * sq_tmp1 + k4 + 2.0 * sq_tmp2 + wc4;
                EQVars v = new EQVars();
                v.b1 = 4.0 * (wc4 + sq_tmp1 - k4 - sq_tmp2) / a_tmp;
                v.b2 = (6.0 * wc4 - 8.0 * wc2 * k2 + 6.0 * k4) / a_tmp;
                v.b3 = 4.0 * (wc4 - sq_tmp1 + sq_tmp2 - k4) / a_tmp;
                v.b4 = (k4 - 2.0 * sq_tmp1 + wc4 - 2.0 * sq_tmp2 + 4.0 * wc2 * k2) / a_tmp;
                v.a0 = wc4 / a_tmp;
                v.a1 = 4.0 * wc4 / a_tmp;
                v.a2 = 6.0 * wc4 / a_tmp;
                v.a3 = v.a1;
                v.a4 = v.a0;
                return v;
            }
        }
        ,
        HPF{

            @Override
            public EQVars getCoefficients(double frequency, double sampleRate) {
                double wc = Math.PI * 2 * frequency;
                double wc2 = wc * wc;
                double wc3 = wc2 * wc;
                double wc4 = wc2 * wc2;
                double k = wc / Math.tan(Math.PI * frequency / sampleRate);
                double k2 = k * k;
                double k3 = k2 * k;
                double k4 = k2 * k2;
                double sqrt2 = Math.sqrt(2.0);
                double sq_tmp1 = sqrt2 * wc3 * k;
                double sq_tmp2 = sqrt2 * wc * k3;
                double a_tmp = 4.0 * wc2 * k2 + 2.0 * sq_tmp1 + k4 + 2.0 * sq_tmp2 + wc4;
                EQVars v = new EQVars();
                v.b1 = 4.0 * (wc4 + sq_tmp1 - k4 - sq_tmp2) / a_tmp;
                v.b2 = (6.0 * wc4 - 8.0 * wc2 * k2 + 6.0 * k4) / a_tmp;
                v.b3 = 4.0 * (wc4 - sq_tmp1 + sq_tmp2 - k4) / a_tmp;
                v.b4 = (k4 - 2.0 * sq_tmp1 + wc4 - 2.0 * sq_tmp2 + 4.0 * wc2 * k2) / a_tmp;
                v.a0 = k4 / a_tmp;
                v.a1 = -4.0 * k4 / a_tmp;
                v.a2 = 6.0 * k4 / a_tmp;
                v.a3 = v.a1;
                v.a4 = v.a0;
                return v;
            }
        };


        public abstract EQVars getCoefficients(double var1, double var3);
    }

    public static class EQVars {
        double a0;
        double a1;
        double a2;
        double a3;
        double a4;
        double b0;
        double b1;
        double b2;
        double b3;
        double b4;
    }
}

