/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.analysis.FourierTransform;
import org.openimaj.audio.filters.HanningAudioProcessor;
import org.openimaj.audio.processor.AudioProcessor;

public class FFTBandPassFilter
extends AudioProcessor {
    private FourierTransform ft = new FourierTransform();
    private HanningAudioProcessor hap = new HanningAudioProcessor(1024);
    private int highPassHz = 500;
    private int lowPassHz = 5000;

    public FFTBandPassFilter(AudioStream as, int highPassHz, int lowPassHz) {
        super(as);
        this.highPassHz = highPassHz;
        this.lowPassHz = lowPassHz;
    }

    public FFTBandPassFilter(int highPassHz, int lowPassHz) {
        this.highPassHz = highPassHz;
        this.lowPassHz = lowPassHz;
    }

    public final SampleChunk process(SampleChunk sample) throws Exception {
        this.ft.process(this.hap.process(sample));
        float[][] transformedData = this.ft.getLastFFT();
        int nc = transformedData.length;
        if (nc > 0) {
            double binSize = sample.getFormat().getSampleRateKHz() * 1000.0 / (double)(transformedData[0].length / 2);
            int highPassBin = (int)Math.floor((double)this.highPassHz / binSize);
            int lowPassBin = (int)Math.ceil((double)this.lowPassHz / binSize);
            for (int c = 0; c < nc; ++c) {
                for (int i = 0; i < transformedData[c].length; ++i) {
                    if (i >= highPassBin && i <= lowPassBin) continue;
                    transformedData[c][i] = 0.0f;
                }
            }
            SampleChunk s = FourierTransform.inverseTransform(sample.getFormat(), transformedData);
            return this.processSamples(s);
        }
        return this.processSamples(sample);
    }

    public SampleChunk processSamples(SampleChunk sc) {
        return sc;
    }
}

