/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.FixedSizeSampleAudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;

public abstract class FIRFilter
extends FixedSizeSampleAudioProcessor {
    private final double[] coefficients = this.getCoefficients();

    public FIRFilter(AudioStream stream) {
        super(stream, 4, 3);
        super.setWindowSize(this.coefficients.length);
        super.setWindowStep(this.coefficients.length - 1);
    }

    public abstract double[] getCoefficients();

    public SampleChunk process(SampleChunk sample) throws Exception {
        SampleBuffer sb = sample.getSampleBuffer();
        for (int c = 0; c < sample.getFormat().getNumChannels(); ++c) {
            float acc = 0.0f;
            for (int i = 0; i < this.coefficients.length; ++i) {
                acc = (float)((double)acc + (double)sb.get(i) * this.coefficients[i]);
            }
            sb.set(0, acc);
        }
        return sample;
    }
}

