/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.filters.FeedForwardCombFilter;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.audio.util.WesternScaleNote;

public class MusicalNoteFilterBank
extends AudioProcessor {
    private int startOfRange = 0;
    private int endOfRange = 0;
    private List<FeedForwardCombFilter> filters = null;
    private AudioFormat format = null;
    private double outputPower = 0.0;

    public MusicalNoteFilterBank(AudioFormat af) {
        this(60, 72, af);
    }

    public MusicalNoteFilterBank(int startOfRange, int endOfRange, AudioFormat af) {
        this.startOfRange = startOfRange;
        this.endOfRange = endOfRange;
        this.format = af;
        if (this.format != null) {
            this.setupFilters();
        }
    }

    private void setupFilters() {
        this.filters = new ArrayList<FeedForwardCombFilter>();
        for (int i = this.startOfRange; i < this.endOfRange; ++i) {
            double f = WesternScaleNote.createNote((int)i).frequency;
            this.filters.add(new FeedForwardCombFilter(f, this.format.getSampleRateKHz() * 1000.0, 1.0));
        }
    }

    public SampleChunk process(SampleChunk sample) throws Exception {
        if (this.filters == null) {
            this.format = sample.getFormat();
            this.setupFilters();
        }
        this.outputPower = 0.0;
        for (FeedForwardCombFilter filter : this.filters) {
            filter.process(sample);
            this.outputPower += filter.getOutputPower();
        }
        return sample;
    }

    public double getOutputPower() {
        return this.outputPower;
    }
}

