/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;

public class Preemphasiser
extends AudioProcessor {
    private double factor = 0.97;

    public Preemphasiser() {
    }

    public Preemphasiser(double factor) {
        this.factor = factor;
    }

    public Preemphasiser(AudioStream as) {
        super(as);
    }

    public Preemphasiser(AudioStream as, double factor) {
        this(as);
        this.factor = factor;
    }

    public SampleChunk process(SampleChunk sample) throws Exception {
        SampleBuffer sb = sample.getSampleBuffer();
        int nc = sb.getFormat().getNumChannels();
        for (int c = 0; c < nc; ++c) {
            float previous = 0.0f;
            for (int s = 1; s < sb.size() / nc; ++s) {
                float v = sb.get(s * c);
                sb.set(s * c, (float)((double)v - this.factor * (double)previous));
                previous = v;
            }
        }
        return sample;
    }
}

