/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;

public class VolumeAdjustProcessor
extends AudioProcessor {
    private double factor = 1.0;

    public VolumeAdjustProcessor(double factor) {
        this(factor, null);
    }

    public VolumeAdjustProcessor(double factor, AudioStream a) {
        super(a);
        this.factor = factor;
    }

    public SampleChunk process(SampleChunk sample) throws Exception {
        switch (sample.getFormat().getNBits()) {
            case 16: {
                ShortBuffer b = sample.getSamplesAsByteBuffer().asShortBuffer();
                for (int x = 0; x < b.limit(); ++x) {
                    b.put(x, (short)((double)b.get(x) * this.factor));
                }
                break;
            }
            case 8: {
                ByteBuffer b = sample.getSamplesAsByteBuffer();
                for (int x = 0; x < b.limit(); ++x) {
                    b.put(x, (byte)((double)b.get(x) * this.factor));
                }
                break;
            }
            default: {
                throw new Exception("Unsupported Format");
            }
        }
        return sample;
    }
}

