/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.generation;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioMixer;
import org.openimaj.audio.Instrument;
import org.openimaj.audio.generation.Synthesizer;
import org.openimaj.audio.generation.SynthesizerListener;

public class PolyphonicSynthesizer
extends AudioMixer
implements Instrument {
    private Map<Integer, Synthesizer> playingSynths = new HashMap<Integer, Synthesizer>();
    private final Stack<Synthesizer> voicePool = new Stack();

    public PolyphonicSynthesizer(int nPolyphony) {
        super(new AudioFormat(16, 44.1, 1));
        this.playingSynths = new HashMap<Integer, Synthesizer>();
        for (int i = 0; i < nPolyphony; ++i) {
            Synthesizer s = new Synthesizer();
            this.voicePool.add(s);
        }
    }

    @Override
    public void noteOn(final int noteNumber, double velocity) {
        System.out.println("Playing: " + this.playingSynths);
        System.out.println("Pool:    " + this.voicePool);
        Synthesizer s = this.playingSynths.get(noteNumber);
        if (s == null && this.voicePool.size() > 0) {
            s = this.voicePool.pop();
        }
        System.out.println("Using synth " + s);
        if (s != null) {
            super.addStream(s, 1.0f);
            this.playingSynths.put(noteNumber, s);
            s.noteOn(noteNumber, velocity);
            final Synthesizer ss = s;
            s.addSynthesizerListener(new SynthesizerListener(){

                @Override
                public void synthQuiet() {
                    System.out.println("Synth quiet " + ss);
                    Synthesizer synth = (Synthesizer)PolyphonicSynthesizer.this.playingSynths.remove(noteNumber);
                    PolyphonicSynthesizer.this.voicePool.push(synth);
                    synth.removeSynthesizerListener(this);
                }
            });
        }
    }

    @Override
    public void noteOff(int noteNumber) {
        Synthesizer s = this.playingSynths.get(noteNumber);
        if (s != null) {
            s.noteOff();
        }
    }

    public int getChannelsInUse() {
        return this.playingSynths.keySet().size();
    }
}

