/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.aop;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.Translator;
import org.apache.log4j.Logger;
import org.openimaj.aop.ClassTransformer;

public class MultiTransformClassFileTransformer
implements ClassFileTransformer,
Translator {
    private static Logger logger = Logger.getLogger(MultiTransformClassFileTransformer.class);
    private ClassPool classPool;
    private List<ClassTransformer> transformers = new ArrayList<ClassTransformer>();

    public MultiTransformClassFileTransformer(ClassTransformer t1, ClassTransformer ... transformers) {
        this.transformers.add(t1);
        for (ClassTransformer ct : transformers) {
            this.transformers.add(ct);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        return this.transform(className, classfileBuffer);
    }

    public byte[] transform(String className, byte[] classfileBuffer) {
        if (this.classPool == null) {
            this.classPool = ClassPool.getDefault();
        }
        try {
            CtClass ctclz = this.classPool.makeClass((InputStream)new ByteArrayInputStream(classfileBuffer));
            this.transform(className, ctclz);
            return ctclz.toBytecode();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("Error transforming class " + className));
            return classfileBuffer;
        }
    }

    private void transform(String className, CtClass ctclz) throws Exception {
        for (ClassTransformer ct : this.transformers) {
            ct.transform(className, ctclz);
        }
    }

    public void start(ClassPool pool) throws NotFoundException, CannotCompileException {
        this.classPool = pool;
    }

    public void onLoad(ClassPool pool, String classname) throws NotFoundException, CannotCompileException {
        if (classname.endsWith(".package-info")) {
            return;
        }
        CtClass clz = pool.get(classname);
        try {
            this.transform(classname, clz);
        }
        catch (Exception e) {
            throw new CannotCompileException((Throwable)e);
        }
    }
}

