/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.aop.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javassist.ClassPool;
import javassist.Loader;
import javassist.Translator;
import org.openimaj.aop.ClassTransformer;
import org.openimaj.aop.MultiTransformClassFileTransformer;

public class ClassLoaderTransform {
    public static final String MAIN_CLASS = "OpenIMAJ-Main-Class";
    public static final String TRANSFORMERS = "OpenIMAJ-Transformers";
    public static final String TRANSFORMERS_SEPARATOR = ",";

    public static Loader run(ClassPool pool, MultiTransformClassFileTransformer tf, File jarFile, String[] args) throws Throwable {
        String mainClass = ClassLoaderTransform.getMainClass(jarFile);
        if (mainClass == null) {
            throw new Exception("Failed to load Main-Class manifest attribute from " + jarFile);
        }
        pool.appendClassPath(jarFile.getAbsolutePath());
        URLClassLoader parent = new URLClassLoader(new URL[]{jarFile.toURI().toURL()});
        return ClassLoaderTransform.run(parent, pool, tf, mainClass, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMainClass(File jarFile) throws IOException {
        JarFile jar = null;
        try {
            String mainClass;
            jar = new JarFile(jarFile);
            Manifest manifest = jar.getManifest();
            Attributes attr = manifest.getMainAttributes();
            String string = mainClass = attr.getValue("Main-Class");
            return string;
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static Loader run(ClassPool pool, MultiTransformClassFileTransformer tf, String classpath, String mainClass, String[] args) throws Throwable {
        String[] paths = classpath.split(File.pathSeparator);
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            urls[i] = new File(paths[i]).toURI().toURL();
        }
        URLClassLoader parent = new URLClassLoader(urls);
        pool.appendPathList(classpath);
        return ClassLoaderTransform.run(parent, pool, tf, mainClass, args);
    }

    public static void run(MultiTransformClassFileTransformer transformer, Class<?> clz, String[] args) throws Throwable {
        ClassPool pool = new ClassPool();
        pool.appendSystemPath();
        Loader loader = new Loader(pool);
        loader.delegateLoadingOf("org.apache.log4j.");
        loader.addTranslator(pool, (Translator)transformer);
        loader.run(clz.getName(), args);
    }

    protected static Loader run(ClassLoader parent, ClassPool pool, MultiTransformClassFileTransformer tf, String mainClass, String[] args) throws Throwable {
        Loader cl = new Loader(parent, pool);
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", mainClass);
        cl.delegateLoadingOf("org.apache.log4j.");
        cl.addTranslator(pool, (Translator)tf);
        cl.run(mainClass, args);
        return cl;
    }

    public static boolean run(Class<?> clz, String[] args, ClassTransformer transformer, ClassTransformer ... transformers) throws Throwable {
        if (!(clz.getClassLoader() instanceof Loader)) {
            MultiTransformClassFileTransformer mtf = new MultiTransformClassFileTransformer(transformer, transformers);
            ClassLoaderTransform.run(mtf, clz, args);
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Throwable {
        Class<ClassLoaderTransform> clazz = ClassLoaderTransform.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        Manifest manifest = new Manifest(new URL(manifestPath).openStream());
        Attributes attr = manifest.getMainAttributes();
        String mainClass = attr.getValue(MAIN_CLASS);
        String[] tfs = attr.getValue(TRANSFORMERS).split(TRANSFORMERS_SEPARATOR);
        ClassTransformer[] cts = new ClassTransformer[tfs.length];
        for (int i = 0; i < tfs.length; ++i) {
            cts[i] = (ClassTransformer)Class.forName(tfs[i]).newInstance();
        }
        ClassPool cp = ClassPool.getDefault();
        ClassLoaderTransform.run(null, cp, new MultiTransformClassFileTransformer(cts[0], Arrays.copyOfRange(cts, 1, cts.length)), mainClass, args);
    }
}

