/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.benchmarks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
public class BlackholeBench {
    private List<String> strs;
    public byte b;
    public boolean bool;
    public char c;
    public short s;
    public int i;
    public long l;
    public float f;
    public double d;
    public Object o;
    public Object[] os;

    @Setup(value=Level.Iteration)
    public void makeGarbage() {
        this.strs = new ArrayList<String>();
        for (int i = 0; i < 100000; ++i) {
            this.strs.add("str" + i);
        }
    }

    @Benchmark
    public void baseline() {
    }

    @Benchmark
    public byte implicit_byte() {
        return this.b;
    }

    @Benchmark
    public boolean implicit_boolean() {
        return this.bool;
    }

    @Benchmark
    public char implicit_char() {
        return this.c;
    }

    @Benchmark
    public short implicit_short() {
        return this.s;
    }

    @Benchmark
    public int implicit_int() {
        return this.i;
    }

    @Benchmark
    public long implicit_long() {
        return this.l;
    }

    @Benchmark
    public float implicit_float() {
        return this.f;
    }

    @Benchmark
    public double implicit_double() {
        return this.d;
    }

    @Benchmark
    public Object implicit_Object() {
        return this.o;
    }

    @Benchmark
    public Object[] implicit_Array() {
        return this.os;
    }

    @Benchmark
    public void explicit_byte(Blackhole bh) {
        bh.consume(this.b);
    }

    @Benchmark
    public void explicit_boolean(Blackhole bh) {
        bh.consume(this.bool);
    }

    @Benchmark
    public void explicit_char(Blackhole bh) {
        bh.consume(this.c);
    }

    @Benchmark
    public void explicit_short(Blackhole bh) {
        bh.consume(this.s);
    }

    @Benchmark
    public void explicit_int(Blackhole bh) {
        bh.consume(this.i);
    }

    @Benchmark
    public void explicit_long(Blackhole bh) {
        bh.consume(this.l);
    }

    @Benchmark
    public void explicit_float(Blackhole bh) {
        bh.consume(this.f);
    }

    @Benchmark
    public void explicit_double(Blackhole bh) {
        bh.consume(this.d);
    }

    @Benchmark
    public void explicit_Object(Blackhole bh) {
        bh.consume(this.o);
    }

    @Benchmark
    public void explicit_Array(Blackhole bh) {
        bh.consume(this.os);
    }
}

