/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.benchmarks;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class BlackholePipelinePayloadBench {
    @Param(value={"10"})
    private int steps;
    private boolean[] booleans;
    private byte[] bytes;
    private short[] shorts;
    private char[] chars;
    private int[] ints;
    private float[] floats;
    private long[] longs;
    private double[] doubles;
    private Double[] objects;
    private Double[][] arrays;

    @Setup
    public void prepare() {
        this.booleans = new boolean[this.steps];
        this.bytes = new byte[this.steps];
        this.shorts = new short[this.steps];
        this.chars = new char[this.steps];
        this.ints = new int[this.steps];
        this.floats = new float[this.steps];
        this.longs = new long[this.steps];
        this.doubles = new double[this.steps];
        this.objects = new Double[this.steps];
        this.arrays = new Double[this.steps][];
        for (int c = 0; c < this.steps; ++c) {
            this.booleans[c] = (c & 1) == 0;
            this.bytes[c] = (byte)c;
            this.shorts[c] = (short)c;
            this.chars[c] = (char)c;
            this.ints[c] = c;
            this.floats[c] = c;
            this.longs[c] = c;
            this.doubles[c] = c;
            this.objects[c] = c;
            this.arrays[c] = new Double[]{c};
        }
    }

    @Benchmark
    public void test_boolean(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(Math.log(this.doubles[c]) > 1.0 ^ this.booleans[c]);
        }
    }

    @Benchmark
    public void test_byte(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume((byte)Math.log(this.bytes[c]));
        }
    }

    @Benchmark
    public void test_short(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume((short)Math.log(this.shorts[c]));
        }
    }

    @Benchmark
    public void test_char(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume((char)Math.log(this.chars[c]));
        }
    }

    @Benchmark
    public void test_int(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume((int)Math.log(this.ints[c]));
        }
    }

    @Benchmark
    public void test_float(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume((float)Math.log(this.floats[c]));
        }
    }

    @Benchmark
    public void test_long(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume((long)Math.log(this.longs[c]));
        }
    }

    @Benchmark
    public void test_double(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(Math.log(this.doubles[c]));
        }
    }

    @Benchmark
    public void test_Object(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume((Object)Math.log(this.objects[c]));
        }
    }

    @Benchmark
    public void test_Array(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume((Object[])new Double[]{Math.log(this.arrays[c][0])});
        }
    }
}

