/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.benchmarks;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@State(value=Scope.Thread)
public class BlackholeValueBench {
    boolean[] array = new boolean[1000];

    @Setup
    public void setup() {
        Random random = new Random(0L);
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = random.nextBoolean();
        }
    }

    @Benchmark
    public void test(Blackhole bh) {
        for (boolean b : this.array) {
            bh.consume(b);
        }
    }
}

