/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.benchmarks;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
public class CompilerHintsBench {
    @Benchmark
    public void baseI_baseline() {
        this.do_Plain(Math.PI);
    }

    @Benchmark
    @Fork(jvmArgsPrepend={"-XX:MaxInlineSize=0", "-XX:FreqInlineSize=0"})
    public void baseNI_baseline() {
        this.do_Plain(Math.PI);
    }

    @Benchmark
    public void baseI_inline() {
        this.do_Inline(Math.PI);
    }

    @Benchmark
    @Fork(jvmArgsPrepend={"-XX:MaxInlineSize=0", "-XX:FreqInlineSize=0"})
    public void baseNI_inline() {
        this.do_Inline(Math.PI);
    }

    @Benchmark
    public void baseI_dontInline() {
        this.do_DontInline(Math.PI);
    }

    @Benchmark
    @Fork(jvmArgsPrepend={"-XX:MaxInlineSize=0", "-XX:FreqInlineSize=0"})
    public void baseNI_dontInline() {
        this.do_DontInline(Math.PI);
    }

    @Benchmark
    public void baseI_exclude() {
        this.do_Exclude(Math.PI);
    }

    @Benchmark
    @Fork(jvmArgsPrepend={"-XX:MaxInlineSize=0", "-XX:FreqInlineSize=0"})
    public void baseNI_exclude() {
        this.do_Exclude(Math.PI);
    }

    private double do_Plain(double x) {
        return Math.log(x);
    }

    @CompilerControl(value=CompilerControl.Mode.INLINE)
    private double do_Inline(double x) {
        return Math.log(x);
    }

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    private double do_DontInline(double x) {
        return Math.log(x);
    }

    @CompilerControl(value=CompilerControl.Mode.EXCLUDE)
    private double do_Exclude(double x) {
        return Math.log(x);
    }
}

